/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.tools.RemoteTool;
import org.opensourcephysics.tools.Tool;
import org.opensourcephysics.tools.ToolsRes;

public class Toolbox {
    protected static Map tools = new HashMap();
    protected static Registry registry;
    protected static int allowRMI;

    static {
        allowRMI = -1;
    }

    protected Toolbox() {
    }

    public static void addTool(String string, Tool tool) {
        if (tools.get(string) == null) {
            tools.put(string, tool);
            OSPLog.fine("Added to toolbox: " + string);
        }
    }

    public static boolean addRMITool(String string, Tool tool) {
        Toolbox.initRMI();
        if (allowRMI == 0) {
            return false;
        }
        try {
            RemoteTool remoteTool = new RemoteTool(tool);
            registry.bind(string, remoteTool);
            OSPLog.fine("Added to RMI registry: " + string);
            return true;
        }
        catch (Exception exception) {
            OSPLog.warning("RMI registration failed: " + string + " [" + exception + "]");
            return false;
        }
    }

    public static Tool getTool(String string) {
        if (tools.containsKey(string)) {
            Tool tool = (Tool)tools.get(string);
            OSPLog.fine("Found local tool: " + string);
            return tool;
        }
        Toolbox.initRMI();
        if (allowRMI == 0) {
            return null;
        }
        try {
            Tool tool = (Tool)registry.lookup(string);
            OSPLog.fine("Found RMI tool " + string);
            return new RemoteTool(tool);
        }
        catch (Exception exception) {
            OSPLog.info("RMI lookup failed: " + string + " [" + exception + "]");
            return null;
        }
    }

    private static void initRMI() {
        if (allowRMI == 0) {
            return;
        }
        int n = JOptionPane.showConfirmDialog(null, ToolsRes.getString("Toolbox.Dialog.UseRemote.Query"), ToolsRes.getString("Toolbox.Dialog.UseRemote.Title"), 0, 3);
        if (n != 0) {
            allowRMI = 0;
            return;
        }
        allowRMI = 1;
        if (registry == null) {
            try {
                registry = LocateRegistry.getRegistry(1099);
                registry.list();
            }
            catch (RemoteException remoteException) {
                try {
                    registry = LocateRegistry.createRegistry(1099);
                }
                catch (RemoteException remoteException2) {
                    OSPLog.info(remoteException2.getMessage());
                }
            }
        }
        if (System.getSecurityManager() == null) {
            try {
                String string = "file:" + System.getProperty("user.dir");
                System.setProperty("java.rmi.server.codebase", String.valueOf(string) + "/classes/");
                System.setProperty("java.security.policy", String.valueOf(string) + "/Remote.policy");
                System.setSecurityManager(new RMISecurityManager());
            }
            catch (Exception exception) {
                OSPLog.info(exception.getMessage());
            }
        }
    }
}

