/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JToolBar;
import javax.swing.SpinnerListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.display.TextFrame;
import org.opensourcephysics.tools.FunctionPanel;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.ToolsRes;

public class FunctionTool
extends JDialog {
    protected static Dimension dim = new Dimension(300, 360);
    protected Map panels = new TreeMap();
    protected HashSet forbiddenNames = new HashSet();
    protected JPanel contentPane = new JPanel(new BorderLayout());
    protected JPanel noData;
    protected JToolBar toolbar;
    protected JLabel spinnerLabel;
    protected SpinnerRollingListModel spinnerModel;
    protected JSpinner spinner;
    protected JPanel north = new JPanel(new BorderLayout());
    protected FunctionPanel selectedPanel;
    protected JButton helpButton;
    protected JButton closeButton;
    protected JPanel buttonbar = new JPanel(new FlowLayout());
    protected JButton[] customButtons;
    protected String helpPath = "";
    protected String helpBase = "http://www.opensourcephysics.org/online_help/tools/";
    protected TextFrame helpFrame;
    protected ActionListener helpAction;

    public FunctionTool(Component component) {
        this(component, null);
    }

    public FunctionTool(Component component, JButton[] jButtonArray) {
        super(JOptionPane.getFrameForComponent(component), false);
        this.customButtons = jButtonArray;
        this.addForbiddenNames(new String[]{"e", "pi", "min", "mod", "sin", "cos", "abs", "log", "acos", "acosh", "ceil", "cosh", "asin", "asinh", "atan", "atanh", "exp", "frac", "floor", "int", "random", "round", "sign", "sinh", "step", "tanh", "atan2", "max", "sqrt", "sqr", "if", "tan"});
        this.setName("FunctionTool");
        this.createGUI();
        this.refreshGUI();
    }

    public FunctionPanel addPanel(String string, FunctionPanel functionPanel) {
        functionPanel.setPreferredSize(dim);
        functionPanel.setName(string);
        functionPanel.setFunctionTool(this);
        this.panels.put(string, functionPanel);
        functionPanel.addForbiddenNames(this.forbiddenNames.toArray(new String[0]));
        this.refreshSpinner(string);
        return functionPanel;
    }

    public FunctionPanel removePanel(String string) {
        FunctionPanel functionPanel = (FunctionPanel)this.panels.get(string);
        if (functionPanel != null) {
            this.panels.remove(string);
            this.refreshSpinner(null);
        }
        return functionPanel;
    }

    public FunctionPanel renamePanel(String string, String string2) {
        FunctionPanel functionPanel = this.getPanel(string);
        if (functionPanel != null) {
            this.panels.remove(string);
            this.panels.put(string2, functionPanel);
            functionPanel.prevName = string;
            functionPanel.setName(string2);
            this.refreshSpinner(string2);
        }
        return functionPanel;
    }

    public void setSelectedPanel(String string) {
        this.spinnerModel.setValue(string);
    }

    public String getSelectedName() {
        if (this.selectedPanel == null) {
            return null;
        }
        for (String string : this.panels.keySet()) {
            if (this.panels.get(string) != this.selectedPanel) continue;
            return string;
        }
        return null;
    }

    public FunctionPanel getSelectedPanel() {
        return this.getPanel(this.getSelectedName());
    }

    public FunctionPanel getPanel(String string) {
        return string == null ? null : (FunctionPanel)this.panels.get(string);
    }

    public void clearPanels() {
        this.panels.clear();
        this.refreshSpinner(null);
    }

    public void addForbiddenNames(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            this.forbiddenNames.add(stringArray[n]);
            ++n;
        }
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.firePropertyChange("visible", null, new Boolean(bl));
    }

    public void setHelpPath(String string) {
        this.helpPath = string;
    }

    public void setHelpAction(ActionListener actionListener) {
        this.helpButton.removeActionListener(this.helpAction);
        this.helpAction = actionListener;
        this.helpButton.addActionListener(this.helpAction);
    }

    public boolean isEmpty() {
        return this.panels.isEmpty();
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        super.firePropertyChange(string, object, object2);
    }

    private void createGUI() {
        ToolsRes.addPropertyChangeListener("locale", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                FunctionTool.this.refreshGUI();
            }
        });
        this.setDefaultCloseOperation(1);
        this.noData = new JPanel(new BorderLayout());
        this.toolbar = new JToolBar();
        this.toolbar.setFloatable(false);
        this.spinnerLabel = new JLabel();
        this.spinnerLabel.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 2));
        this.spinnerLabel.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                String string = FunctionTool.this.getSelectedName();
                if (string != null) {
                    FunctionPanel functionPanel = (FunctionPanel)FunctionTool.this.panels.get(string);
                    functionPanel.clearSelection();
                }
            }
        });
        this.toolbar.add(this.spinnerLabel);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(ToolsRes.getString("FunctionTool.Empty.Name"));
        this.spinnerModel = new SpinnerRollingListModel(arrayList);
        this.spinner = new JSpinner(this.spinnerModel);
        JSpinner.DefaultEditor defaultEditor = (JSpinner.DefaultEditor)this.spinner.getEditor();
        defaultEditor.getTextField().setBackground(Color.white);
        defaultEditor.getTextField().setEditable(false);
        this.spinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                String string = FunctionTool.this.spinner.getValue().toString();
                FunctionTool.this.select(string);
                FunctionPanel functionPanel = (FunctionPanel)FunctionTool.this.panels.get(string);
                if (functionPanel != null) {
                    functionPanel.getFunctionTable().clearSelection();
                    functionPanel.getFunctionTable().selectOnFocus = false;
                    functionPanel.getParamTable().clearSelection();
                    functionPanel.getParamTable().selectOnFocus = false;
                    functionPanel.refreshGUI();
                }
                FunctionTool.this.helpButton.requestFocus();
            }
        });
        this.toolbar.add(this.spinner);
        if (this.customButtons != null) {
            this.toolbar.addSeparator();
            int n = 0;
            while (n < this.customButtons.length) {
                this.toolbar.add(this.customButtons[n]);
                ++n;
            }
        }
        this.north.add((Component)this.toolbar, "North");
        this.north.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.closeButton = new JButton();
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FunctionTool.this.setVisible(false);
            }
        });
        this.helpAction = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (FunctionTool.this.helpFrame == null) {
                    Object object;
                    String string = XML.getResolvedPath(FunctionTool.this.helpPath, FunctionTool.this.helpBase);
                    if (ResourceLoader.getResource(string) != null) {
                        FunctionTool.this.helpFrame = new TextFrame(string);
                    } else {
                        object = "/org/opensourcephysics/resources/tools/html/";
                        string = XML.getResolvedPath(FunctionTool.this.helpPath, (String)object);
                        FunctionTool.this.helpFrame = new TextFrame(string);
                    }
                    FunctionTool.this.helpFrame.setSize(700, 550);
                    object = Toolkit.getDefaultToolkit().getScreenSize();
                    int n = (((Dimension)object).width - FunctionTool.this.helpFrame.getBounds().width) / 2;
                    int n2 = (((Dimension)object).height - FunctionTool.this.helpFrame.getBounds().height) / 2;
                    FunctionTool.this.helpFrame.setLocation(n, n2);
                }
                FunctionTool.this.helpFrame.setVisible(true);
            }
        };
        this.helpButton = new JButton();
        this.helpButton.addActionListener(this.helpAction);
        this.buttonbar.setBorder(BorderFactory.createEtchedBorder());
        this.buttonbar.add(this.helpButton);
        this.buttonbar.add(this.closeButton);
        this.contentPane.setPreferredSize(dim);
        this.contentPane.add((Component)this.north, "North");
        this.contentPane.add((Component)this.noData, "Center");
        this.contentPane.add((Component)this.buttonbar, "South");
        this.setContentPane(this.contentPane);
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = (dimension.width - this.getBounds().width) / 2;
        int n2 = (dimension.height - this.getBounds().height) / 2;
        this.setLocation(n, n2);
    }

    protected void refreshGUI() {
        if (this.selectedPanel != null) {
            String string = this.selectedPanel.getLabel();
            this.spinnerLabel.setText(String.valueOf(string) + ":");
        }
        this.spinner.setToolTipText(ToolsRes.getString("FunctionTool.Spinner.Tooltip"));
        this.closeButton.setText(ToolsRes.getString("Tool.Button.Close"));
        this.closeButton.setToolTipText(ToolsRes.getString("Tool.Button.Close.ToolTip"));
        this.helpButton.setText(ToolsRes.getString("Tool.Button.Help"));
        this.helpButton.setToolTipText(ToolsRes.getString("Tool.Button.Help.ToolTip"));
        for (FunctionPanel functionPanel : this.panels.values()) {
            functionPanel.refreshGUI();
        }
    }

    private void refreshSpinner(Object object) {
        if (object == null) {
            object = this.spinner.getValue();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(this.panels.keySet());
        if (arrayList.isEmpty()) {
            arrayList.add(ToolsRes.getString("FunctionTool.Empty.Name"));
        }
        this.spinnerModel.setList(arrayList, object);
    }

    private void select(String string) {
        FunctionPanel functionPanel = string == null ? null : (FunctionPanel)this.panels.get(string);
        FunctionPanel functionPanel2 = this.selectedPanel;
        if (this.selectedPanel != null) {
            this.contentPane.remove(this.selectedPanel);
        } else {
            this.contentPane.remove(this.noData);
        }
        this.selectedPanel = functionPanel;
        this.spinner.setEnabled(functionPanel != null);
        this.spinnerLabel.setEnabled(functionPanel != null);
        if (functionPanel != null) {
            this.contentPane.add((Component)functionPanel, "Center");
            functionPanel.refreshGUI();
        } else {
            this.contentPane.add((Component)this.noData, "Center");
            this.buttonbar.removeAll();
            this.buttonbar.add(this.helpButton);
            this.buttonbar.add(this.closeButton);
        }
        this.validate();
        this.refreshGUI();
        this.repaint();
        this.firePropertyChange("panel", functionPanel2, functionPanel);
    }

    protected String getUniqueName(String string) {
        int n = 1;
        String string2 = String.valueOf(string) + n;
        while (this.panels.keySet().contains(string2) || this.forbiddenNames.contains(string2)) {
            string2 = String.valueOf(string) + ++n;
        }
        return string2;
    }

    class SpinnerRollingListModel
    extends SpinnerListModel {
        boolean fireStateChange;

        SpinnerRollingListModel(List list) {
            super(list);
            this.fireStateChange = true;
        }

        protected void fireStateChanged() {
            if (this.fireStateChange) {
                super.fireStateChanged();
            }
        }

        public void setList(List list, Object object) {
            this.fireStateChange = object == null || list.indexOf(object) <= 0;
            super.setList(list);
            this.fireStateChange = true;
            if (object != null && list.contains(object)) {
                this.setValue(object);
            }
        }

        public Object getNextValue() {
            Object object = super.getNextValue();
            if (object == null && this.getList().size() > 0) {
                object = this.getList().get(0);
            }
            return object;
        }

        public Object getPreviousValue() {
            Object object = super.getPreviousValue();
            int n = this.getList().size();
            if (object == null && n > 0) {
                object = this.getList().get(n - 1);
            }
            return object;
        }
    }
}

