/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import javax.swing.table.AbstractTableModel;

public class ArrayTableModel
extends AbstractTableModel {
    double[] doubleArray1;
    double[][] doubleArray2;
    int[] intArray1;
    int[][] intArray2;
    String[] stringArray1;
    String[][] stringArray2;
    boolean[] booleanArray1;
    boolean[][] booleanArray2;
    boolean editable = false;

    public ArrayTableModel(int[] nArray) {
        this.intArray1 = nArray;
    }

    public ArrayTableModel(int[][] nArray) {
        this.intArray2 = nArray;
    }

    public ArrayTableModel(double[] dArray) {
        this.doubleArray1 = dArray;
    }

    public ArrayTableModel(double[][] dArray) {
        this.doubleArray2 = dArray;
    }

    public ArrayTableModel(String[] stringArray) {
        this.stringArray1 = stringArray;
    }

    public ArrayTableModel(String[][] stringArray) {
        this.stringArray2 = stringArray;
    }

    public ArrayTableModel(boolean[] blArray) {
        this.booleanArray1 = blArray;
    }

    public ArrayTableModel(boolean[][] blArray) {
        this.booleanArray2 = blArray;
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    public int getColumnCount() {
        if (this.getRowCount() == 0) {
            return 0;
        }
        if (this.intArray1 != null || this.doubleArray1 != null || this.stringArray1 != null || this.booleanArray1 != null) {
            return 2;
        }
        if (this.intArray2 != null) {
            return this.intArray2[0].length + 1;
        }
        if (this.doubleArray2 != null) {
            return this.doubleArray2[0].length + 1;
        }
        if (this.stringArray2 != null) {
            return this.stringArray2[0].length + 1;
        }
        if (this.booleanArray2 != null) {
            return this.booleanArray2[0].length + 1;
        }
        return 0;
    }

    public String getColumnName(int n) {
        if (n == 0) {
            return "";
        }
        if (this.intArray1 != null || this.doubleArray1 != null || this.stringArray1 != null || this.booleanArray1 != null) {
            return "value";
        }
        return "" + (n - 1);
    }

    public int getRowCount() {
        if (this.intArray1 != null) {
            return this.intArray1.length;
        }
        if (this.intArray2 != null) {
            return this.intArray2.length;
        }
        if (this.doubleArray1 != null) {
            return this.doubleArray1.length;
        }
        if (this.doubleArray2 != null) {
            return this.doubleArray2.length;
        }
        if (this.stringArray1 != null) {
            return this.stringArray1.length;
        }
        if (this.stringArray2 != null) {
            return this.stringArray2.length;
        }
        if (this.booleanArray1 != null) {
            return this.booleanArray1.length;
        }
        if (this.booleanArray2 != null) {
            return this.booleanArray2.length;
        }
        return 0;
    }

    public Object getValueAt(int n, int n2) {
        if (n2 == 0) {
            return new Integer(n);
        }
        if (this.intArray1 != null) {
            return new Integer(this.intArray1[n]);
        }
        if (this.intArray2 != null) {
            return new Integer(this.intArray2[n][n2 - 1]);
        }
        if (this.doubleArray1 != null) {
            return new Double(this.doubleArray1[n]);
        }
        if (this.doubleArray2 != null) {
            return new Double(this.doubleArray2[n][n2 - 1]);
        }
        if (this.stringArray1 != null) {
            return this.stringArray1[n];
        }
        if (this.stringArray2 != null) {
            return this.stringArray2[n][n2 - 1];
        }
        if (this.booleanArray1 != null) {
            return new Boolean(this.booleanArray1[n]);
        }
        if (this.booleanArray2 != null) {
            return new Boolean(this.booleanArray2[n][n2 - 1]);
        }
        return null;
    }

    public boolean isCellEditable(int n, int n2) {
        return this.editable && n2 > 0;
    }

    public void setValueAt(Object object, int n, int n2) {
        if (object instanceof String) {
            String string = (String)object;
            if (this.intArray1 != null) {
                try {
                    this.intArray1[n] = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (this.intArray2 != null) {
                try {
                    this.intArray2[n][n2 - 1] = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (this.doubleArray1 != null) {
                try {
                    this.doubleArray1[n] = Double.parseDouble(string);
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (this.doubleArray2 != null) {
                try {
                    this.doubleArray2[n][n2 - 1] = Double.parseDouble(string);
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (this.stringArray1 != null) {
                this.stringArray1[n] = string;
            } else if (this.stringArray2 != null) {
                this.stringArray2[n][n2 - 1] = string;
            } else if (this.booleanArray1 != null) {
                this.booleanArray1[n] = string.toLowerCase().startsWith("t");
            } else if (this.booleanArray2 != null) {
                this.booleanArray2[n][n2 - 1] = string.toLowerCase().startsWith("t");
            }
            this.fireTableCellUpdated(n, n2);
        }
    }
}

