/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.numerics.ArrayLib;
import org.opensourcephysics.numerics.LUPDecomposition;
import org.opensourcephysics.numerics.MultiVarFunction;

public class HessianMinimize {
    int Iterations;
    double[][] H;
    double[] xp;
    double[] xm;
    double[] xpp;
    double[] xpm;
    double[] xmp;
    double[] xmm;
    private double rmsd_tmp;
    private double rmsd;
    private double[] xtmp;

    public double minimize(MultiVarFunction multiVarFunction, double[] dArray, int n, double d) {
        int n2 = dArray.length;
        double[] dArray2 = new double[n2];
        double[] dArray3 = new double[n2];
        double[] dArray4 = new double[n2];
        this.xtmp = new double[n2];
        System.arraycopy(dArray, 0, this.xtmp, 0, n2);
        this.rmsd_tmp = multiVarFunction.evaluate(dArray);
        this.rmsd = 0.0;
        this.crudeGuess(multiVarFunction, dArray);
        this.check_rmsd(multiVarFunction, this.xtmp, dArray, n2);
        int n3 = 0;
        while (n3 < n2) {
            dArray4[n3] = (Math.abs(dArray[n3]) + 1.0) / 100000.0;
            ++n3;
        }
        double d2 = 9999.0;
        double d3 = 9999.0;
        this.Iterations = 0;
        while (d2 > d * 1.0E-6 && d3 > d * 1.0E-6 && this.Iterations < n) {
            ++this.Iterations;
            LUPDecomposition lUPDecomposition = new LUPDecomposition(this.getHessian(multiVarFunction, dArray, dArray3, dArray4));
            dArray2 = lUPDecomposition.solve(dArray3);
            int n4 = 0;
            while (n4 < n2) {
                dArray2[n4] = dArray2[n4] + dArray[n4];
                ++n4;
            }
            d2 = (dArray[0] - dArray2[0]) * (dArray[0] - dArray2[0]);
            d3 = dArray[0] * dArray[0];
            dArray[0] = dArray2[0];
            n4 = 1;
            while (n4 < n2) {
                d2 += (dArray[n4] - dArray2[n4]) * (dArray[n4] - dArray2[n4]);
                d3 += dArray[n4] * dArray[n4];
                dArray[n4] = dArray2[n4];
                ++n4;
            }
            d2 = Math.sqrt(d2);
            d3 = d2 / (d3 + d);
        }
        this.check_rmsd(multiVarFunction, this.xtmp, dArray, n2);
        return d2;
    }

    private void allocateArrays(int n) {
        this.H = new double[n][n];
        this.xp = new double[n];
        this.xm = new double[n];
        this.xpp = new double[n];
        this.xpm = new double[n];
        this.xmp = new double[n];
        this.xmm = new double[n];
    }

    void crudeGuess(MultiVarFunction multiVarFunction, double[] dArray) {
        int n = dArray.length;
        int n2 = 5;
        double d = 0.35;
        int n3 = 0;
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        double[] dArray4 = new double[n];
        int n4 = 0;
        while (n4 < n) {
            dArray4[n4] = (Math.abs(dArray[n4]) + 1.0) / 1000.0;
            ++n4;
        }
        while (n3 < n2) {
            ++n3;
            n4 = 0;
            while (n4 < n) {
                int n5 = 0;
                while (n5 < n) {
                    if (n5 == n4) {
                        dArray2[n4] = dArray[n4] + dArray4[n4];
                        dArray3[n4] = dArray[n4] - dArray4[n4];
                    } else {
                        dArray2[n5] = dArray[n5];
                        dArray3[n5] = dArray[n5];
                    }
                    ++n5;
                }
                double d2 = multiVarFunction.evaluate(dArray2);
                double d3 = multiVarFunction.evaluate(dArray);
                double d4 = multiVarFunction.evaluate(dArray3);
                dArray[n4] = dArray[n4] - d * 0.5 * dArray4[n4] * (d2 - d4) / (d2 - 2.0 * d3 + d4);
                dArray4[n4] = 0.5 * dArray4[n4];
                ++n4;
            }
        }
    }

    void check_rmsd(MultiVarFunction multiVarFunction, double[] dArray, double[] dArray2, int n) {
        if (Double.isNaN(ArrayLib.sum(dArray2))) {
            this.rmsd = this.rmsd_tmp;
            System.arraycopy(dArray, 0, dArray2, 0, n);
        } else {
            this.rmsd = multiVarFunction.evaluate(dArray2);
            if (this.rmsd <= this.rmsd_tmp) {
                this.rmsd_tmp = this.rmsd;
                System.arraycopy(dArray2, 0, dArray, 0, n);
            } else {
                this.rmsd = this.rmsd_tmp;
                System.arraycopy(dArray, 0, dArray2, 0, n);
            }
        }
    }

    public int getIterations() {
        return this.Iterations;
    }

    public double[][] getHessian(MultiVarFunction multiVarFunction, double[] dArray, double[] dArray2, double[] dArray3) {
        int n;
        int n2 = dArray.length;
        if (this.xp == null || this.xp.length != n2) {
            this.allocateArrays(n2);
        }
        int n3 = 0;
        while (n3 < n2) {
            n = n3;
            while (n < n2) {
                int n4;
                if (n3 == n) {
                    n4 = 0;
                    while (n4 < n2) {
                        this.xp[n4] = dArray[n4];
                        this.xm[n4] = dArray[n4];
                        ++n4;
                    }
                    this.xp[n3] = dArray[n3] + dArray3[n3];
                    this.xm[n3] = dArray[n3] - dArray3[n3];
                    this.H[n3][n3] = (multiVarFunction.evaluate(this.xp) - 2.0 * multiVarFunction.evaluate(dArray) + multiVarFunction.evaluate(this.xm)) / (dArray3[n3] * dArray3[n3]);
                } else {
                    n4 = 0;
                    while (n4 < n2) {
                        this.xpp[n4] = dArray[n4];
                        this.xpm[n4] = dArray[n4];
                        this.xmp[n4] = dArray[n4];
                        this.xmm[n4] = dArray[n4];
                        ++n4;
                    }
                    this.xpp[n3] = dArray[n3] + dArray3[n3];
                    this.xpp[n] = dArray[n] + dArray3[n];
                    this.xpm[n3] = dArray[n3] + dArray3[n3];
                    this.xpm[n] = dArray[n] - dArray3[n];
                    this.xmp[n3] = dArray[n3] - dArray3[n3];
                    this.xmp[n] = dArray[n] + dArray3[n];
                    this.xmm[n3] = dArray[n3] - dArray3[n3];
                    this.xmm[n] = dArray[n] - dArray3[n];
                    this.H[n3][n] = ((multiVarFunction.evaluate(this.xpp) - multiVarFunction.evaluate(this.xpm)) / (2.0 * dArray3[n]) - (multiVarFunction.evaluate(this.xmp) - multiVarFunction.evaluate(this.xmm)) / (2.0 * dArray3[n])) / (2.0 * dArray3[n3]);
                    this.H[n][n3] = this.H[n3][n];
                }
                ++n;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < n2) {
            n = 0;
            while (n < n2) {
                this.xp[n] = dArray[n];
                this.xm[n] = dArray[n];
                ++n;
            }
            this.xp[n3] = dArray[n3] + dArray3[n3];
            this.xm[n3] = dArray[n3] - dArray3[n3];
            dArray2[n3] = -(multiVarFunction.evaluate(this.xp) - multiVarFunction.evaluate(this.xm)) / (2.0 * dArray3[n3]);
            ++n3;
        }
        return this.H;
    }
}

