/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import java.text.DecimalFormat;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;

public class DoubleArray {
    public static int NumberFormatError = 1;
    public static int ArrayIndexOutOfBoundsError = 2;
    protected DecimalFormat format = new DecimalFormat("0.00");
    protected DecimalFormat formatExp = new DecimalFormat("0.00#E0");
    protected double[] array;
    protected String defaultString;
    protected double[] defaultArray;
    protected int errorcode = 0;

    public DoubleArray(int n) {
        this.array = new double[n];
        this.defaultArray = this.array;
    }

    public DoubleArray(double[] dArray) {
        this.defaultArray = (double[])dArray.clone();
        this.array = this.defaultArray;
    }

    public DoubleArray(String string) throws NumberFormatException {
        this.array = this.toDouble(string);
        this.defaultString = string;
        this.defaultArray = this.array;
    }

    public void setDecimalFormat(String string) {
        this.formatExp = this.format = new DecimalFormat(string);
    }

    public String getDefault() {
        return this.defaultString;
    }

    public String toString() {
        if (this.errorcode > 0) {
            return this.defaultString;
        }
        String string = "{";
        int n = 0;
        int n2 = this.array.length;
        while (n < n2) {
            string = String.valueOf(string) + (Math.abs(this.array[n]) < 0.1 || Math.abs(this.array[n]) > 1000.0 ? this.formatExp.format(this.array[n]) : this.format.format(this.array[n]));
            if (n < n2 - 1) {
                string = String.valueOf(string) + ", ";
            }
            ++n;
        }
        string = String.valueOf(string) + "}";
        return string;
    }

    public int getError() {
        return this.errorcode;
    }

    public double[] getArray(String string) {
        this.set(string);
        return this.array;
    }

    public double[] getArray() {
        return this.array;
    }

    public boolean set(String string) {
        this.errorcode = 0;
        try {
            this.array = this.toDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.errorcode = NumberFormatError;
            this.array = this.toDouble(this.defaultString);
            return false;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.errorcode = ArrayIndexOutOfBoundsError;
            this.array = this.toDouble(this.defaultString);
            return false;
        }
        return true;
    }

    public void setDefaultArray(double[] dArray) {
        this.defaultArray = (double[])dArray.clone();
        this.array = this.defaultArray;
    }

    protected double[] toDouble(String string) throws ArrayIndexOutOfBoundsException {
        if (string == null) {
            string = "{}";
        }
        double[] dArray = null;
        int n = string.indexOf("{") + 1;
        int n2 = string.indexOf("}");
        if (n2 - n <= 0) {
            this.errorcode = ArrayIndexOutOfBoundsError;
            return this.defaultArray;
        }
        String[] stringArray = string.substring(n, n2).split(",");
        if (this.array != null && this.array.length != stringArray.length) {
            throw new ArrayIndexOutOfBoundsException("Array length cannot be changed in DoubleArray. " + string);
        }
        dArray = new double[stringArray.length];
        int n3 = 0;
        int n4 = stringArray.length;
        while (n3 < n4) {
            try {
                dArray[n3] = Double.parseDouble(stringArray[n3]);
            }
            catch (NumberFormatException numberFormatException) {
                this.errorcode = NumberFormatError;
            }
            ++n3;
        }
        return dArray;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        public void saveObject(XMLControl xMLControl, Object object) {
            DoubleArray doubleArray = (DoubleArray)object;
            xMLControl.setValue("data", doubleArray.getArray());
        }

        public Object createObject(XMLControl xMLControl) {
            return new DoubleArray((double[])xMLControl.getObject("data"));
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            DoubleArray doubleArray = (DoubleArray)object;
            double[] dArray = (double[])xMLControl.getObject("data");
            doubleArray.array = dArray;
            doubleArray.defaultArray = dArray;
            return object;
        }
    }
}

