/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.gif;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.opensourcephysics.media.gif.LZWEncoder;
import org.opensourcephysics.media.gif.NeuQuant;

public class AnimatedGifEncoder {
    protected int width;
    protected int height;
    protected Color transparent = null;
    protected int transIndex;
    protected int repeat = -1;
    protected int delay = 0;
    protected boolean started = false;
    protected OutputStream out;
    protected BufferedImage image;
    protected byte[] pixels;
    protected byte[] indexedPixels;
    protected int colorDepth;
    protected byte[] colorTab;
    protected boolean[] usedEntry = new boolean[256];
    protected int palSize = 7;
    protected int dispose = -1;
    protected boolean closeStream = false;
    protected boolean firstFrame = true;
    protected boolean sizeSet = false;
    protected int sample = 10;

    public void setDelay(int n) {
        this.delay = Math.round((float)n / 10.0f);
    }

    public void setDispose(int n) {
        if (n >= 0) {
            this.dispose = n;
        }
    }

    public void setRepeat(int n) {
        if (n >= 0) {
            this.repeat = n;
        }
    }

    public void setTransparent(Color color) {
        this.transparent = color;
    }

    public boolean addFrame(BufferedImage bufferedImage) {
        if (bufferedImage == null || !this.started) {
            return false;
        }
        boolean bl = true;
        try {
            if (!this.sizeSet) {
                this.setSize(bufferedImage.getWidth(), bufferedImage.getHeight());
            }
            this.image = bufferedImage;
            this.getImagePixels();
            this.analyzePixels();
            if (this.firstFrame) {
                this.writeLSD();
                this.writePalette();
                if (this.repeat >= 0) {
                    this.writeNetscapeExt();
                }
            }
            this.writeGraphicCtrlExt();
            this.writeImageDesc();
            if (!this.firstFrame) {
                this.writePalette();
            }
            this.writePixels();
            this.firstFrame = false;
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public boolean finish() {
        if (!this.started) {
            return false;
        }
        boolean bl = true;
        this.started = false;
        try {
            this.out.write(59);
            this.out.flush();
            if (this.closeStream) {
                this.out.close();
            }
        }
        catch (IOException iOException) {
            bl = false;
        }
        this.transIndex = 0;
        this.out = null;
        this.image = null;
        this.pixels = null;
        this.indexedPixels = null;
        this.colorTab = null;
        this.closeStream = false;
        this.firstFrame = true;
        return bl;
    }

    public void setFrameRate(float f) {
        if (f != 0.0f) {
            this.delay = Math.round(100.0f / f);
        }
    }

    public void setQuality(int n) {
        if (n < 1) {
            n = 1;
        }
        this.sample = n;
    }

    public void setSize(int n, int n2) {
        if (this.started && !this.firstFrame) {
            return;
        }
        this.width = n;
        this.height = n2;
        if (this.width < 1) {
            this.width = 320;
        }
        if (this.height < 1) {
            this.height = 240;
        }
        this.sizeSet = true;
    }

    public boolean start(OutputStream outputStream) {
        if (outputStream == null) {
            return false;
        }
        boolean bl = true;
        this.closeStream = false;
        this.out = outputStream;
        try {
            this.writeString("GIF89a");
        }
        catch (IOException iOException) {
            bl = false;
        }
        this.started = bl;
        return this.started;
    }

    public boolean start(String string) {
        boolean bl = true;
        try {
            this.out = new BufferedOutputStream(new FileOutputStream(string));
            bl = this.start(this.out);
            this.closeStream = true;
        }
        catch (IOException iOException) {
            bl = false;
        }
        this.started = bl;
        return this.started;
    }

    protected void analyzePixels() {
        int n;
        int n2 = this.pixels.length;
        int n3 = n2 / 3;
        this.indexedPixels = new byte[n3];
        NeuQuant neuQuant = new NeuQuant(this.pixels, n2, this.sample);
        this.colorTab = neuQuant.process();
        int n4 = 0;
        while (n4 < this.colorTab.length) {
            n = this.colorTab[n4];
            this.colorTab[n4] = this.colorTab[n4 + 2];
            this.colorTab[n4 + 2] = n;
            this.usedEntry[n4 / 3] = false;
            n4 += 3;
        }
        n4 = 0;
        n = 0;
        while (n < n3) {
            int n5 = neuQuant.map(this.pixels[n4++] & 0xFF, this.pixels[n4++] & 0xFF, this.pixels[n4++] & 0xFF);
            this.usedEntry[n5] = true;
            this.indexedPixels[n] = (byte)n5;
            ++n;
        }
        this.pixels = null;
        this.colorDepth = 8;
        this.palSize = 7;
        if (this.transparent != null) {
            this.transIndex = this.findClosest(this.transparent);
        }
    }

    protected int findClosest(Color color) {
        if (this.colorTab == null) {
            return -1;
        }
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        int n4 = 0;
        int n5 = 0x1000000;
        int n6 = this.colorTab.length;
        int n7 = 0;
        while (n7 < n6) {
            int n8 = n - (this.colorTab[n7++] & 0xFF);
            int n9 = n2 - (this.colorTab[n7++] & 0xFF);
            int n10 = n3 - (this.colorTab[n7] & 0xFF);
            int n11 = n8 * n8 + n9 * n9 + n10 * n10;
            int n12 = n7 / 3;
            if (this.usedEntry[n12] && n11 < n5) {
                n5 = n11;
                n4 = n12;
            }
            ++n7;
        }
        return n4;
    }

    protected void getImagePixels() {
        int n = this.image.getWidth();
        int n2 = this.image.getHeight();
        int n3 = this.image.getType();
        if (n != this.width || n2 != this.height || n3 != 5) {
            BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 5);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.drawImage((Image)this.image, 0, 0, null);
            this.image = bufferedImage;
        }
        this.pixels = ((DataBufferByte)this.image.getRaster().getDataBuffer()).getData();
    }

    protected void writeGraphicCtrlExt() throws IOException {
        int n;
        int n2;
        this.out.write(33);
        this.out.write(249);
        this.out.write(4);
        if (this.transparent == null) {
            n2 = 0;
            n = 0;
        } else {
            n2 = 1;
            n = 2;
        }
        if (this.dispose >= 0) {
            n = this.dispose & 7;
        }
        this.out.write((n <<= 2) | n2);
        this.writeShort(this.delay);
        this.out.write(this.transIndex);
        this.out.write(0);
    }

    protected void writeImageDesc() throws IOException {
        this.out.write(44);
        this.writeShort(0);
        this.writeShort(0);
        this.writeShort(this.width);
        this.writeShort(this.height);
        if (this.firstFrame) {
            this.out.write(0);
        } else {
            this.out.write(0x80 | this.palSize);
        }
    }

    protected void writeLSD() throws IOException {
        this.writeShort(this.width);
        this.writeShort(this.height);
        this.out.write(0xF0 | this.palSize);
        this.out.write(0);
        this.out.write(0);
    }

    protected void writeNetscapeExt() throws IOException {
        this.out.write(33);
        this.out.write(255);
        this.out.write(11);
        this.writeString("NETSCAPE2.0");
        this.out.write(3);
        this.out.write(1);
        this.writeShort(this.repeat);
        this.out.write(0);
    }

    protected void writePalette() throws IOException {
        this.out.write(this.colorTab, 0, this.colorTab.length);
        int n = 768 - this.colorTab.length;
        int n2 = 0;
        while (n2 < n) {
            this.out.write(0);
            ++n2;
        }
    }

    protected void writePixels() throws IOException {
        LZWEncoder lZWEncoder = new LZWEncoder(this.width, this.height, this.indexedPixels, this.colorDepth);
        lZWEncoder.encode(this.out);
    }

    protected void writeShort(int n) throws IOException {
        this.out.write(n & 0xFF);
        this.out.write(n >> 8 & 0xFF);
    }

    protected void writeString(String string) throws IOException {
        int n = 0;
        while (n < string.length()) {
            this.out.write((byte)string.charAt(n));
            ++n;
        }
    }
}

