/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.dialogs.DecimalField;
import org.opensourcephysics.display.dialogs.DialogsRes;

public class ScaleInspector
extends JDialog {
    protected DrawingPanel plotPanel;
    protected JPanel dataPanel;
    protected JLabel xMinLabel;
    protected JLabel xMaxLabel;
    protected JLabel yMinLabel;
    protected JLabel yMaxLabel;
    protected DecimalField xMinField;
    protected DecimalField xMaxField;
    protected DecimalField yMinField;
    protected DecimalField yMaxField;
    protected JCheckBox xAutoscaleCheckBox;
    protected JCheckBox yAutoscaleCheckBox;
    protected JButton okButton;
    protected JButton cancelButton;

    public ScaleInspector(DrawingPanel drawingPanel) {
        super((Frame)null, true);
        this.plotPanel = drawingPanel;
        this.setTitle(DialogsRes.SCALE_SCALE);
        this.setResizable(false);
        this.createGUI();
        this.pack();
    }

    private void createGUI() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.setContentPane(jPanel);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel.add((Component)jPanel2, "South");
        this.xMinLabel = new JLabel(DialogsRes.SCALE_MIN);
        this.xMinField = new DecimalField(5, 1);
        this.xMinField.setMaximumSize(this.xMinField.getPreferredSize());
        this.xMinField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                double d = ScaleInspector.this.plotPanel.getPreferredXMax();
                ScaleInspector.this.plotPanel.setPreferredMinMaxX(ScaleInspector.this.xMinField.getValue(), d);
                ScaleInspector.this.plotPanel.repaint();
                ScaleInspector.this.updateDisplay();
                ScaleInspector.this.xMinField.selectAll();
            }
        });
        this.xMinField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                ScaleInspector.this.xMinField.selectAll();
            }

            public void focusLost(FocusEvent focusEvent) {
                double d = ScaleInspector.this.plotPanel.getPreferredXMax();
                ScaleInspector.this.plotPanel.setPreferredMinMaxX(ScaleInspector.this.xMinField.getValue(), d);
                ScaleInspector.this.plotPanel.repaint();
                ScaleInspector.this.updateDisplay();
            }
        });
        this.xAutoscaleCheckBox = new JCheckBox(DialogsRes.SCALE_AUTO);
        this.xAutoscaleCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ScaleInspector.this.xMinField.setEnabled(!ScaleInspector.this.xAutoscaleCheckBox.isSelected());
                ScaleInspector.this.xMaxField.setEnabled(!ScaleInspector.this.xAutoscaleCheckBox.isSelected());
                ScaleInspector.this.plotPanel.setAutoscaleX(ScaleInspector.this.xAutoscaleCheckBox.isSelected());
                ScaleInspector.this.plotPanel.scale();
                ScaleInspector.this.updateDisplay();
                ScaleInspector.this.plotPanel.repaint();
            }
        });
        this.xMaxLabel = new JLabel(DialogsRes.SCALE_MAX);
        this.xMaxField = new DecimalField(5, 1);
        this.xMaxField.setMaximumSize(this.xMaxField.getPreferredSize());
        this.xMaxField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                double d = ScaleInspector.this.plotPanel.getPreferredXMin();
                ScaleInspector.this.plotPanel.setPreferredMinMaxX(d, ScaleInspector.this.xMaxField.getValue());
                ScaleInspector.this.plotPanel.repaint();
                ScaleInspector.this.updateDisplay();
                ScaleInspector.this.xMaxField.selectAll();
            }
        });
        this.xMaxField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                ScaleInspector.this.xMaxField.selectAll();
            }

            public void focusLost(FocusEvent focusEvent) {
                double d = ScaleInspector.this.plotPanel.getPreferredXMin();
                ScaleInspector.this.plotPanel.setPreferredMinMaxX(d, ScaleInspector.this.xMaxField.getValue());
                ScaleInspector.this.plotPanel.repaint();
                ScaleInspector.this.updateDisplay();
            }
        });
        this.yMinLabel = new JLabel(DialogsRes.SCALE_MIN);
        this.yMinField = new DecimalField(5, 1);
        this.yMinField.setMaximumSize(this.yMinField.getPreferredSize());
        this.yMinField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                double d = ScaleInspector.this.plotPanel.getPreferredYMax();
                ScaleInspector.this.plotPanel.setPreferredMinMaxY(ScaleInspector.this.yMinField.getValue(), d);
                ScaleInspector.this.plotPanel.repaint();
                ScaleInspector.this.updateDisplay();
                ScaleInspector.this.yMinField.selectAll();
            }
        });
        this.yMinField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                ScaleInspector.this.yMinField.selectAll();
            }

            public void focusLost(FocusEvent focusEvent) {
                double d = ScaleInspector.this.plotPanel.getPreferredYMax();
                ScaleInspector.this.plotPanel.setPreferredMinMaxY(ScaleInspector.this.yMinField.getValue(), d);
                ScaleInspector.this.plotPanel.repaint();
                ScaleInspector.this.updateDisplay();
            }
        });
        this.yAutoscaleCheckBox = new JCheckBox(DialogsRes.SCALE_AUTO);
        this.yAutoscaleCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ScaleInspector.this.yMinField.setEnabled(!ScaleInspector.this.yAutoscaleCheckBox.isSelected());
                ScaleInspector.this.yMaxField.setEnabled(!ScaleInspector.this.yAutoscaleCheckBox.isSelected());
                ScaleInspector.this.plotPanel.setAutoscaleY(ScaleInspector.this.yAutoscaleCheckBox.isSelected());
                ScaleInspector.this.plotPanel.scale();
                ScaleInspector.this.updateDisplay();
                ScaleInspector.this.plotPanel.repaint();
            }
        });
        this.yMaxLabel = new JLabel(DialogsRes.SCALE_MAX);
        this.yMaxField = new DecimalField(5, 1);
        this.yMaxField.setMaximumSize(this.yMaxField.getPreferredSize());
        this.yMaxField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                double d = ScaleInspector.this.plotPanel.getPreferredYMin();
                ScaleInspector.this.plotPanel.setPreferredMinMaxY(d, ScaleInspector.this.yMaxField.getValue());
                ScaleInspector.this.plotPanel.repaint();
                ScaleInspector.this.updateDisplay();
                ScaleInspector.this.yMaxField.selectAll();
            }
        });
        this.yMaxField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                ScaleInspector.this.yMaxField.selectAll();
            }

            public void focusLost(FocusEvent focusEvent) {
                double d = ScaleInspector.this.plotPanel.getPreferredYMin();
                ScaleInspector.this.plotPanel.setPreferredMinMaxY(d, ScaleInspector.this.yMaxField.getValue());
                ScaleInspector.this.plotPanel.repaint();
                ScaleInspector.this.updateDisplay();
            }
        });
        JPanel jPanel3 = new JPanel(new GridLayout(3, 1));
        String string = "x";
        jPanel3.setBorder(BorderFactory.createTitledBorder(string));
        JPanel jPanel4 = new JPanel(new GridLayout(3, 1));
        string = "y";
        jPanel4.setBorder(BorderFactory.createTitledBorder(string));
        this.dataPanel = new JPanel(new GridLayout(2, 1));
        this.dataPanel.setBorder(BorderFactory.createEtchedBorder());
        jPanel2.add((Component)this.dataPanel, "Center");
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add(this.xMinLabel);
        box.add(this.xMinField);
        jPanel3.add(this.xAutoscaleCheckBox);
        jPanel3.add(box);
        box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add(this.xMaxLabel);
        box.add(this.xMaxField);
        jPanel3.add(box);
        box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add(this.yMinLabel);
        box.add(this.yMinField);
        jPanel4.add(this.yAutoscaleCheckBox);
        jPanel4.add(box);
        box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add(this.yMaxLabel);
        box.add(this.yMaxField);
        jPanel4.add(box);
        this.dataPanel.add(jPanel3);
        this.dataPanel.add(jPanel4);
        this.xMinLabel.setAlignmentX(1.0f);
        this.xMaxLabel.setAlignmentX(1.0f);
        this.yMinLabel.setAlignmentX(1.0f);
        this.yMaxLabel.setAlignmentX(1.0f);
        this.xMinField.setAlignmentX(1.0f);
        this.xMaxField.setAlignmentX(1.0f);
        this.yMinField.setAlignmentX(1.0f);
        this.yMaxField.setAlignmentX(1.0f);
        this.xAutoscaleCheckBox.setAlignmentX(1.0f);
        this.yAutoscaleCheckBox.setAlignmentX(1.0f);
        this.cancelButton = new JButton(DialogsRes.SCALE_CANCEL);
        this.cancelButton.setForeground(new Color(0, 0, 102));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ScaleInspector.this.revert();
                ScaleInspector.this.setVisible(false);
            }
        });
        this.okButton = new JButton(DialogsRes.SCALE_OK);
        this.okButton.setForeground(new Color(0, 0, 102));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ScaleInspector.this.setVisible(false);
            }
        });
        JPanel jPanel5 = new JPanel();
        jPanel2.add((Component)jPanel5, "South");
        jPanel5.add(this.okButton);
    }

    public void updateDisplay() {
        this.xAutoscaleCheckBox.setSelected(this.plotPanel.isAutoscaleX());
        this.xMinField.setEnabled(!this.xAutoscaleCheckBox.isSelected());
        this.xMaxField.setEnabled(!this.xAutoscaleCheckBox.isSelected());
        this.xMinField.setValue(this.plotPanel.getPreferredXMin());
        this.xMaxField.setValue(this.plotPanel.getPreferredXMax());
        this.yAutoscaleCheckBox.setSelected(this.plotPanel.isAutoscaleY());
        this.yMinField.setEnabled(!this.yAutoscaleCheckBox.isSelected());
        this.yMaxField.setEnabled(!this.yAutoscaleCheckBox.isSelected());
        this.yMinField.setValue(this.plotPanel.getPreferredYMin());
        this.yMaxField.setValue(this.plotPanel.getPreferredYMax());
    }

    private void revert() {
    }
}

