/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;

public class TextFrame
extends JFrame {
    JTextPane textPane = new JTextPane();
    JScrollPane textScroller;

    public TextFrame() {
        this((String)null, (Class)null);
    }

    public TextFrame(String string) {
        this(string, (Class)null);
    }

    public TextFrame(String string, Class clazz) {
        this.setSize(300, 300);
        this.textPane.setEditable(false);
        this.textScroller = new JScrollPane(this.textPane);
        this.setContentPane(this.textScroller);
        if (string != null) {
            this.loadResource(string, clazz);
        }
    }

    public JTextPane getTextPane() {
        return this.textPane;
    }

    public void enableHyperlinks() {
        this.textPane.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        TextFrame.this.textPane.setPage(hyperlinkEvent.getURL());
                    }
                    catch (IOException iOException) {}
                }
            }
        });
    }

    public boolean loadResource(String string, Class clazz) {
        Resource resource = null;
        try {
            resource = ResourceLoader.getResource(string, clazz);
        }
        catch (Exception exception) {
            OSPLog.fine("Error getting resource: " + string);
            return false;
        }
        if (resource == null) {
            OSPLog.fine("Resource not found: " + string);
            return false;
        }
        try {
            this.textPane.setPage(resource.getURL());
        }
        catch (IOException iOException) {
            OSPLog.fine("Resource not loadeded: " + string);
            return false;
        }
        this.setTitle(string);
        return true;
    }
}

