/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.external;

import com.calerga.sysquake.SQLinkVariableListener;
import com.calerga.sysquake.SysquakeLink;
import java.io.File;
import java.util.Hashtable;
import java.util.Vector;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.external.ExternalApp;
import org.colos.ejs.library.external.ExternalClient;
import org.opensourcephysics.display.OSPRuntime;

public class EjsSysquake
implements ExternalApp,
SQLinkVariableListener {
    private static SysquakeLink sqlink = null;
    private static String homeDir = null;
    private static boolean alreadyLoaded = false;
    private static int numberOfEngines = 0;
    private static int dllCounter = -1;
    private int sqID = -1;
    private String sqFile = null;
    private ExternalClient client = null;
    private Hashtable varTable = new Hashtable();

    private static SysquakeLink tryThisOne(String string) {
        File file = new File(string);
        try {
            string = file.getCanonicalPath();
        }
        catch (Exception exception) {
            string = file.getAbsolutePath();
        }
        if (file.exists()) {
            return new SysquakeLink(string);
        }
        return null;
    }

    private static void initSysquake() {
        if (sqlink != null) {
            return;
        }
        homeDir = null;
        String string = System.getProperty("user.dir").replace('\\', '/');
        if (!string.endsWith("/")) {
            string = String.valueOf(string) + "/";
        }
        if (OSPRuntime.isWindows()) {
            sqlink = EjsSysquake.tryThisOne(String.valueOf(string) + Simulation.getPathToLibrary() + "_library/external/SysquakeLink.dll");
            if (sqlink == null) {
                sqlink = EjsSysquake.tryThisOne(String.valueOf(string) + "_library/external/SysquakeLink.dll");
            }
            if (sqlink == null) {
                homeDir = Simulation.getTemporaryDir();
                if (!alreadyLoaded) {
                    dllCounter = 0;
                    int n = 1;
                    while (n <= 50) {
                        File file = new File(String.valueOf(homeDir) + "_library/external/SysquakeLink" + n + ".dll");
                        if (file.exists()) {
                            file.delete();
                        } else if (dllCounter == 0) {
                            dllCounter = n;
                            if (Simulation.extractResource("../_library/external/SysquakeLink.dll", file.getPath()) != null) {
                                Simulation.extractResource("_library/external/SysquakeLink.dll", file.getPath());
                            }
                        }
                        ++n;
                    }
                    alreadyLoaded = true;
                }
                sqlink = EjsSysquake.tryThisOne(String.valueOf(homeDir) + "_library/external/SysquakeLink" + dllCounter + ".dll");
            }
        } else {
            new SysquakeLink(String.valueOf(string) + "_library/external/libSysquakeLink.jnilib");
        }
    }

    public EjsSysquake(String string) {
        EjsSysquake.initSysquake();
        String string2 = null;
        if (homeDir != null) {
            string2 = homeDir;
        } else {
            string2 = System.getProperty("user.dir").replace('\\', '/');
            if (!string2.endsWith("/")) {
                string2 = String.valueOf(string2) + "/";
            }
        }
        if (string != null) {
            this.sqFile = string.trim();
            if (this.sqFile.length() == 0 || this.sqFile.toLowerCase().startsWith("<sysquake>")) {
                this.sqFile = null;
            } else if (!(homeDir == null && new File(String.valueOf(string2) + this.sqFile).exists() || Simulation.extractResource(this.sqFile, String.valueOf(string2 = Simulation.getTemporaryDir()) + this.sqFile) == null)) {
                System.out.println("Warning : the sq file " + this.sqFile + " does not exist!");
                this.sqFile = null;
            }
            if (this.sqFile != null) {
                this.sqFile = String.valueOf(string2) + this.sqFile;
            }
        }
        try {
            SysquakeLink.connect();
        }
        catch (Exception exception) {
            System.err.println("EjsSysquake error: " + exception);
        }
        if (!SysquakeLink.isConnected()) {
            System.out.println("Warning : Sysquake is NOT connected!!!");
        }
        this.loadSQFile();
    }

    private synchronized void loadSQFile() {
        try {
            SysquakeLink.resetVariableChangeNotification(this.sqID);
            if (this.sqID != -1) {
                // empty if block
            }
            if (this.sqFile == null) {
                this.sqID = -1;
                return;
            }
            SysquakeLink.show();
            this.sqID = SysquakeLink.open(this.sqFile);
            if (this.sqID == -1) {
                return;
            }
            SysquakeLink.setVariableChangeNotification(this.sqID, this);
            String[] stringArray = SysquakeLink.variableNames(this.sqID);
            if (stringArray != null) {
                int n = 0;
                int n2 = stringArray.length;
                while (n < n2) {
                    String string = stringArray[n];
                    if (!string.startsWith("_")) {
                        this.varTable.put(stringArray[n], new Integer(n));
                    }
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            System.err.println("EjsSysquake error: " + exception);
        }
    }

    public void variableChange(int n) {
        if (n != this.sqID) {
            System.out.println("Wrong Sysquake ID!");
            return;
        }
        if (this.client != null) {
            this.client._externalGetValuesAndUpdate(false, this);
        }
    }

    public String toString() {
        return this.sqFile;
    }

    public void setClient(ExternalClient externalClient) {
        this.client = externalClient;
    }

    public void setInitCommand(String string) {
    }

    public void eval(String string) {
        try {
            SysquakeLink.execute(string);
        }
        catch (Exception exception) {
            System.err.println("EjsSysquake error: " + exception);
        }
    }

    public synchronized void eval(String string, boolean bl) {
        this.eval(string);
    }

    public void resetIC() {
    }

    public void resetParam() {
    }

    public synchronized void step(double d) {
    }

    public void stepAS(double d) {
    }

    public void stepAS(double d, int n) {
    }

    public synchronized void reset() {
        try {
            SysquakeLink.disconnect();
            SysquakeLink.connect();
            this.loadSQFile();
        }
        catch (Exception exception) {
            System.err.println("EjsSysquake error: " + exception);
        }
    }

    public synchronized void quit() {
        try {
            if (this.sqID != -1) {
                SysquakeLink.resetVariableChangeNotification(this.sqID);
            }
            SysquakeLink.disconnect();
            this.sqID = -1;
            SysquakeLink.quit();
            sqlink = null;
        }
        catch (Exception exception) {
            System.err.println("EjsSysquake error: " + exception);
        }
    }

    public void setValues(Vector vector, Vector vector2) throws Exception {
        if (this.sqID == -1) {
            return;
        }
        int n = vector.size();
        if (n <= 0) {
            return;
        }
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            Integer n3 = (Integer)this.varTable.get((String)vector.get(n2));
            if (n3 != null) {
                nArray[n2] = n3;
            } else {
                System.out.println("EjsSysquake Error: Variable " + vector.get(n2) + " not found");
                nArray[n2] = -1;
            }
            ++n2;
        }
        SysquakeLink.setVariableValue(this.sqID, nArray, vector2.toArray());
    }

    public void setValue(String string, String string2) throws Exception {
        Integer n = (Integer)this.varTable.get(string);
        if (n != null) {
            SysquakeLink.setVariableValue(this.sqID, string, (Object)string2);
        } else {
            SysquakeLink.execute(String.valueOf(string) + " = '" + string2 + "';");
        }
    }

    public void setValue(String string, double d) throws Exception {
        Integer n = (Integer)this.varTable.get(string);
        if (n != null) {
            SysquakeLink.setVariableValue(this.sqID, string, (Object)new Double(d));
        } else {
            SysquakeLink.execute(String.valueOf(string) + " = " + d + ";");
        }
    }

    public void setValue(String string, double[] dArray) throws Exception {
        Integer n = (Integer)this.varTable.get(string);
        if (n != null) {
            SysquakeLink.setVariableValue(this.sqID, string, (Object)dArray);
        } else {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.append(" = [ ");
            int n2 = 0;
            while (n2 < dArray.length) {
                if (n2 > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(Double.toString(dArray[n2]));
                ++n2;
            }
            stringBuffer.append("];");
            SysquakeLink.execute(stringBuffer.toString());
        }
    }

    public void setValue(String string, double[][] dArray) throws Exception {
        Integer n = (Integer)this.varTable.get(string);
        if (n != null) {
            SysquakeLink.setVariableValue(this.sqID, string, (Object)dArray);
        } else {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.append(" = [ ");
            int n2 = 0;
            while (n2 < dArray.length) {
                if (n2 > 0) {
                    stringBuffer.append(";");
                }
                int n3 = 0;
                while (n3 < dArray[n2].length) {
                    if (n3 > 0) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(Double.toString(dArray[n2][n3]));
                    ++n3;
                }
                ++n2;
            }
            stringBuffer.append("];");
            SysquakeLink.execute(stringBuffer.toString());
        }
    }

    public synchronized String getString(String string) throws Exception {
        Object object = null;
        Integer n = (Integer)this.varTable.get(string);
        object = n != null ? SysquakeLink.variableValue(this.sqID, string) : SysquakeLink.lmeVariableValue(string);
        return (String)object;
    }

    public double getDouble(String string) {
        Object object = null;
        Integer n = (Integer)this.varTable.get(string);
        try {
            object = n != null ? SysquakeLink.variableValue(this.sqID, string) : SysquakeLink.lmeVariableValue(string);
        }
        catch (Exception exception) {
            System.err.println("EjsSysquake error: " + exception);
        }
        if (object == null) {
            return Double.NaN;
        }
        return (Double)object;
    }

    public synchronized double[] getDoubleArray(String string) {
        Object object = null;
        Integer n = (Integer)this.varTable.get(string);
        try {
            object = n != null ? SysquakeLink.variableValue(this.sqID, string) : SysquakeLink.lmeVariableValue(string);
            if (object instanceof double[][]) {
                return ((double[][])object)[0];
            }
            return (double[])object;
        }
        catch (Exception exception) {
            System.err.println("EjsSysquake error: " + exception);
            return null;
        }
    }

    public double[][] getDoubleArray2D(String string) {
        Object object = null;
        Integer n = (Integer)this.varTable.get(string);
        try {
            object = n != null ? SysquakeLink.variableValue(this.sqID, string) : SysquakeLink.lmeVariableValue(string);
        }
        catch (Exception exception) {
            System.err.println("EjsSysquake error: " + exception);
        }
        return (double[][])object;
    }

    public synchronized void update(String string, String string2, int n) {
    }

    public synchronized void update(String string, String string2, int n, int n2) {
    }

    public synchronized void haltUpdate(boolean bl) {
    }

    public synchronized void haltStepAS(boolean bl) {
    }

    public void setValue(String string, double[][] dArray, boolean bl) throws Exception {
        this.setValue(string, dArray);
    }

    public void setValue(String string, double[] dArray, boolean bl) throws Exception {
        this.setValue(string, dArray);
    }

    public synchronized void setValue(String string, String string2, boolean bl) throws Exception {
        this.setValue(string, string2);
    }

    public void setValue(String string, double d, boolean bl) throws Exception {
        this.setValue(string, d);
    }

    public synchronized String getStringAS() throws Exception {
        return null;
    }

    public double getDoubleAS() {
        return 0.0;
    }

    public synchronized void synchronize(boolean bl) {
    }

    public synchronized void synchronize() {
    }

    public synchronized void externalVars(String string) {
    }

    public synchronized void setCommand(String string) {
    }

    public synchronized void packageSize(double d) {
    }

    public synchronized double[] getDoubleArrayAS() {
        return null;
    }

    public double[][] getDoubleArray2DAS() {
        return null;
    }
}

