/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library;

import ch.epfl.cockpit.communication.DatasFile;
import ch.epfl.cockpit.communication.GraphicsFile;
import ch.epfl.cockpit.communication.HashTableMessage;
import ch.epfl.cockpit.communication.Message;
import ch.epfl.cockpit.communication.ParamsFileXML;
import ch.epfl.cockpit.communication.Request;
import ch.epfl.cockpit.communication.ServletMessenger;
import ch.epfl.cockpit.communication.TextFile;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Image;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JApplet;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.colos.ejs.library.Simulation;

public class EmersionLink {
    private URL eMersionURL = null;
    private String eMersionSessionID = null;
    private Component parentComponent = null;
    private Simulation simulation = null;
    private SavePanel savePanel = new SavePanel();
    private ReadPanel readPanel = new ReadPanel();

    public EmersionLink(JApplet jApplet, Simulation simulation) {
        this.simulation = simulation;
        String string = jApplet.getParameter("eMersionURL");
        try {
            this.eMersionURL = new URL(string);
            this.eMersionSessionID = jApplet.getParameter("eMersionSessionID");
        }
        catch (MalformedURLException malformedURLException) {
            if (string != null) {
                System.out.println("Malformed URL exception for URL = <" + string + ">");
            }
            this.eMersionURL = null;
            this.eMersionSessionID = null;
        }
    }

    public boolean isConnected() {
        return this.eMersionURL != null && this.eMersionSessionID != null;
    }

    public void setParentComponent(Component component) {
        this.parentComponent = component;
    }

    public void setNameLabel(String string) {
        this.savePanel.nameLabel.setText(string);
    }

    public void setAnnotationLabel(String string) {
        this.savePanel.annotationLabel.setText(string);
    }

    public String saveBinary(String string, String string2, byte[] byArray) {
        if (!this.isConnected()) {
            return null;
        }
        if (!this.savePanel.showSaveOptions(string, string2)) {
            return null;
        }
        string = this.savePanel.nameField.getText().trim();
        if (string.length() <= 0) {
            return null;
        }
        string2 = this.savePanel.annotationField.getText();
        try {
            ServletMessenger servletMessenger = new ServletMessenger(this.eMersionURL);
            DatasFile datasFile = new DatasFile(this.eMersionSessionID, string, string2, byArray);
            servletMessenger.send(datasFile);
        }
        catch (Exception exception) {
            this.showException(exception);
            return null;
        }
        return string;
    }

    public String saveImage(String string, String string2, Image image) {
        if (!this.isConnected()) {
            return null;
        }
        if (!string.toLowerCase().endsWith(".gif")) {
            string = String.valueOf(string) + ".gif";
        }
        if (!this.savePanel.showSaveOptions(string, string2)) {
            return null;
        }
        string = this.savePanel.nameField.getText().trim();
        if (string.length() <= 0) {
            return null;
        }
        string2 = this.savePanel.annotationField.getText();
        if (string.toLowerCase().endsWith(".gif")) {
            string = string.substring(0, string.length() - 4);
        }
        try {
            ServletMessenger servletMessenger = new ServletMessenger(this.eMersionURL);
            GraphicsFile graphicsFile = new GraphicsFile(this.eMersionSessionID, string, image);
            graphicsFile.setAnnotation(string2);
            servletMessenger.send(graphicsFile);
        }
        catch (Exception exception) {
            this.showException(exception);
            return null;
        }
        return string;
    }

    public String saveText(String string, String string2, String string3) {
        if (!this.isConnected()) {
            return null;
        }
        if (!this.savePanel.showSaveOptions(string, string2)) {
            return null;
        }
        string = this.savePanel.nameField.getText().trim();
        if (string.length() <= 0) {
            return null;
        }
        string2 = this.savePanel.annotationField.getText();
        try {
            ServletMessenger servletMessenger = new ServletMessenger(this.eMersionURL);
            TextFile textFile = new TextFile(this.eMersionSessionID, string, string2, string3);
            servletMessenger.send(textFile);
        }
        catch (Exception exception) {
            this.showException(exception);
            return null;
        }
        return string;
    }

    public String saveXML(String string, String string2, String string3) {
        if (!this.isConnected()) {
            return null;
        }
        if (!this.savePanel.showSaveOptions(string, string2)) {
            return null;
        }
        string = this.savePanel.nameField.getText().trim();
        if (string.length() <= 0) {
            return null;
        }
        string2 = this.savePanel.annotationField.getText();
        try {
            ServletMessenger servletMessenger = new ServletMessenger(this.eMersionURL);
            ParamsFileXML paramsFileXML = new ParamsFileXML(this.eMersionSessionID, string, string2, string3);
            servletMessenger.send(paramsFileXML);
        }
        catch (Exception exception) {
            this.showException(exception);
            return null;
        }
        return string;
    }

    public byte[] readBinary(String string) {
        if (!this.isConnected()) {
            return null;
        }
        String string2 = this.readPanel.chooseFragment("type_binary_set");
        if (string2 == null) {
            return null;
        }
        ServletMessenger servletMessenger = new ServletMessenger(this.eMersionURL);
        Request request = new Request(this.eMersionSessionID, "fragment", "type_binary_set");
        request.setFragID(string2);
        try {
            servletMessenger.send(request);
            Message message = (Message)servletMessenger.getFeedback();
            System.out.println("Response:" + message.toString());
            System.out.println("Response feedback:" + message.getStatus());
            DatasFile datasFile = (DatasFile)message;
            return datasFile.getContent();
        }
        catch (Exception exception) {
            this.showException(exception);
            return null;
        }
    }

    public String readText(String string) {
        if (!this.isConnected()) {
            return null;
        }
        String string2 = this.readPanel.chooseFragment("type_text_set");
        if (string2 == null) {
            return null;
        }
        ServletMessenger servletMessenger = new ServletMessenger(this.eMersionURL);
        Request request = new Request(this.eMersionSessionID, "fragment", "type_text_set");
        request.setFragID(string2);
        try {
            servletMessenger.send(request);
            Message message = (Message)servletMessenger.getFeedback();
            System.out.println("Response:" + message.toString());
            System.out.println("Response feedback:" + message.getStatus());
            TextFile textFile = (TextFile)message;
            String string3 = textFile.getText();
            return string3;
        }
        catch (Exception exception) {
            this.showException(exception);
            return null;
        }
    }

    public String readXML(String string) {
        if (!this.isConnected()) {
            return null;
        }
        String string2 = this.readPanel.chooseFragment("type_params_set");
        if (string2 == null) {
            return null;
        }
        ServletMessenger servletMessenger = new ServletMessenger(this.eMersionURL);
        Request request = new Request(this.eMersionSessionID, "fragment", "type_params_set");
        request.setFragID(string2);
        try {
            servletMessenger.send(request);
            Message message = (Message)servletMessenger.getFeedback();
            System.out.println("Response:" + message.toString());
            System.out.println("Response feedback:" + message.getStatus());
            ParamsFileXML paramsFileXML = (ParamsFileXML)message;
            String string3 = paramsFileXML.getParamsXML();
            return string3;
        }
        catch (Exception exception) {
            this.showException(exception);
            return null;
        }
    }

    public Image readImage(String string) {
        if (!this.isConnected()) {
            return null;
        }
        String string2 = this.readPanel.chooseFragment("type_binary_set");
        System.out.println("File for reading image from eMersion is " + string2);
        return null;
    }

    private Component getParentComponent() {
        if (this.simulation != null) {
            return this.simulation.getParentComponent();
        }
        return this.parentComponent;
    }

    private void showException(Exception exception) {
        exception.printStackTrace();
        System.out.println("A dialog should appear now");
        JOptionPane.showMessageDialog(this.getParentComponent(), exception.getLocalizedMessage());
    }

    private String chooseFragment(String string) {
        Enumeration enumeration;
        Hashtable hashtable;
        block5: {
            ServletMessenger servletMessenger = new ServletMessenger(this.eMersionURL);
            Request request = new Request(this.eMersionSessionID, "list", string, true);
            servletMessenger.send(request);
            Message message = (Message)servletMessenger.getFeedback();
            HashTableMessage hashTableMessage = (HashTableMessage)message;
            hashtable = hashTableMessage.getContent();
            enumeration = hashtable.keys();
            if (hashtable.size() != 0) break block5;
            JOptionPane.showMessageDialog(this.getParentComponent(), "No fragments available of type:" + string, "Emersion", 0);
            return null;
        }
        try {
            Object[] objectArray = new Object[hashtable.size()];
            int n = 0;
            while (enumeration.hasMoreElements()) {
                objectArray[n] = enumeration.nextElement().toString();
                ++n;
            }
            Object object = JOptionPane.showInputDialog(this.getParentComponent(), "Choose one", "Input", 1, null, objectArray, objectArray[0]);
            if (object != null) {
                return (String)hashtable.get(object);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    private class ReadPanel
    extends JPanel {
        JLabel nameLabel;
        JLabel annotationLabel;
        JTextField nameField;
        JTextField annotationField;
        DefaultListModel listModel = new DefaultListModel();
        JList list = new JList(this.listModel);

        ReadPanel() {
            this.list.setSelectionMode(0);
            JScrollPane jScrollPane = new JScrollPane(this.list);
            this.setLayout(new BorderLayout());
            this.add((Component)jScrollPane, "Center");
        }

        String chooseFragment(String string) {
            ServletMessenger servletMessenger = new ServletMessenger(EmersionLink.this.eMersionURL);
            Request request = new Request(EmersionLink.this.eMersionSessionID, "list", string, true);
            try {
                int n;
                servletMessenger.send(request);
                Message message = (Message)servletMessenger.getFeedback();
                HashTableMessage hashTableMessage = (HashTableMessage)message;
                Hashtable hashtable = hashTableMessage.getContent();
                this.listModel.removeAllElements();
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    this.listModel.addElement(enumeration.nextElement());
                }
                if (hashtable.size() > 0) {
                    this.list.setSelectedIndex(0);
                }
                if ((n = JOptionPane.showConfirmDialog(EmersionLink.this.getParentComponent(), this, "eMersion", 2)) == 0) {
                    return (String)hashtable.get(this.list.getSelectedValue());
                }
            }
            catch (Exception exception) {
                EmersionLink.this.showException(exception);
            }
            return null;
        }
    }

    private class SavePanel
    extends JPanel {
        JLabel nameLabel = new JLabel("Name");
        JLabel annotationLabel;
        JTextField nameField;
        JTextField annotationField;

        SavePanel() {
            this.nameLabel.setHorizontalAlignment(0);
            this.nameLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
            this.nameField = new JTextField();
            this.nameField.setColumns(10);
            this.annotationLabel = new JLabel("Annotation");
            this.annotationLabel.setHorizontalAlignment(0);
            this.annotationLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
            this.annotationField = new JTextField();
            this.annotationField.setColumns(10);
            JPanel jPanel = new JPanel(new GridLayout(0, 1));
            jPanel.add(this.nameLabel);
            jPanel.add(this.annotationLabel);
            JPanel jPanel2 = new JPanel(new GridLayout(0, 1));
            jPanel2.add(this.nameField);
            jPanel2.add(this.annotationField);
            this.setLayout(new BorderLayout());
            this.add((Component)jPanel, "West");
            this.add((Component)jPanel2, "Center");
        }

        boolean showSaveOptions(String string, String string2) {
            int n;
            if (string != null) {
                this.nameField.setText(string);
            }
            if (string2 != null) {
                this.annotationField.setText(string2);
            }
            return (n = JOptionPane.showConfirmDialog(EmersionLink.this.getParentComponent(), this, "eMersion", 2)) == 0;
        }
    }
}

