/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.cockpit.communication;

import ch.epfl.cockpit.communication.Compression;
import ch.epfl.cockpit.communication.SaveableMessage;
import ch.epfl.cockpit.utilities.Conversion;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;

public class GraphicsFile
extends SaveableMessage {
    private int[] pixels;
    private byte[] compressedPixels;
    boolean compressed = false;
    private Dimension imageDim;

    public GraphicsFile() {
    }

    public GraphicsFile(String string, String string2, String string3, Image image) {
        this.setSessionID(string);
        this.setFileName(string2);
        this.setAnnotation(string3);
        this.setImage(image);
    }

    public GraphicsFile(String string, String string2, Image image) {
        this.setSessionID(string);
        this.setFileName(string2);
        this.setImage(image);
    }

    public GraphicsFile(Image image, boolean bl) {
        this.setImage(image, bl);
    }

    public void setImage(Image image) {
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        this.imageDim = new Dimension(n, n2);
        this.pixels = new int[n * n2];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n, n2, this.pixels, 0, n);
        try {
            boolean bl = pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            System.out.println("Problem while grabbing pixels.");
        }
    }

    public void setImage(Image image, boolean bl) {
        this.setImage(image);
        if (bl) {
            this.compressPixels();
        }
    }

    public Image getImage() {
        if (this.compressed) {
            this.decompressPixels();
        }
        return new Frame().createImage(new MemoryImageSource(this.imageDim.width, this.imageDim.height, this.pixels, 0, this.imageDim.width));
    }

    public int[][] getPixels2D() {
        this.decompressPixels();
        if (this.pixels != null) {
            int[][] nArray = new int[this.imageDim.width][this.imageDim.height];
            int n = this.imageDim.width;
            while (n-- > 0) {
                int n2 = this.imageDim.height;
                while (n2-- > 0) {
                    nArray[n][n2] = this.pixels[n2 * this.imageDim.width + n];
                }
            }
            return nArray;
        }
        return null;
    }

    public Dimension getDimension() {
        return this.imageDim;
    }

    public void compressPixels() {
        if (!this.compressed && this.pixels != null) {
            byte[] byArray = Conversion.intToBytes((int[])this.pixels);
            this.compressedPixels = Compression.compressFullArray(byArray, 9);
            this.pixels = null;
            this.compressed = true;
        }
    }

    private void decompressPixels() {
        if (this.compressed) {
            byte[] byArray = Compression.decompressFullArray(this.compressedPixels);
            this.pixels = Conversion.bytesToInt((byte[])byArray);
            this.compressedPixels = null;
            this.compressed = false;
        }
    }
}

