/*
 * Decompiled with CFR 0.152.
 */
package EP.EP_chapter21.Wave_representations_v5;

import EP.EP_chapter21.Wave_representations_v5.Wave_representations_v5Simulation;
import EP.EP_chapter21.Wave_representations_v5.Wave_representations_v5View;
import java.awt.Color;
import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.external.ExternalApp;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.ResourceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Wave_representations_v5
extends AbstractModel {
    public Wave_representations_v5Simulation _simulation = null;
    public Wave_representations_v5View _view = null;
    public Wave_representations_v5 _model = this;
    public double A = 0.1;
    public double w = 1.0;
    public double lambda = 1.0;
    public double k = Math.PI * 2 / this.lambda;
    public double xval = 0.0;
    public double xval2 = 1.0;
    public double T = 0.0;
    public double v = 0.0;
    public double vmax = 0.0;
    public double t = 0.0;
    public double dt = 0.05;
    public boolean helpFlag = false;
    public String helpLabel = "Show Help";
    public boolean showAnswerFlag = false;
    public double enterA1 = 0.0;
    public String A1correct = "  ?";
    public Object A1correctbackground = null;
    public double enterlambda = 0.0;
    public String lambdacorrect = "  ?";
    public Object lambdacorrectbackground = null;
    public double enterT = 0.0;
    public String Tcorrect = "  ?";
    public Object Tcorrectbackground = null;
    public double enteromega = 0.0;
    public String omegacorrect = "  ?";
    public Object omegacorrectbackground = null;
    public double enterv = 0.0;
    public String vcorrect = "  ?";
    public Object vcorrectbackground = null;
    public double entervmax = 0.0;
    public String vmaxcorrect = "  ?";
    public Object vmaxcorrectbackground = null;
    public int redness = 200;
    public int greenness = 220;
    public int blueness = 208;
    public Object backColor = null;

    public static String _getEjsModel() {
        return "EP/EP_chapter21/Wave_representations_v5.xml";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        return hashSet;
    }

    public static void main(String[] stringArray) {
        OSPRuntime.javaLookAndFeel = true;
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        ResourceLoader.addSearchPath("EP/EP_chapter21/");
        boolean bl = false;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("C:/Documents and Settings/andrew/Desktop/Ejs2008/Ejs_4.0/bin/");
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl) {
            Simulation.setPathToLibrary("C:/Documents and Settings/andrew/Desktop/Ejs2008/Ejs_4.0/bin/");
        }
        Wave_representations_v5 wave_representations_v5 = new Wave_representations_v5(stringArray);
    }

    public Wave_representations_v5() {
        this(null, null, null, null, null, false);
    }

    public Wave_representations_v5(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public Wave_representations_v5(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new Wave_representations_v5Simulation(this, string, frame, uRL, bl);
        this._view = (Wave_representations_v5View)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _initialization1() {
        this.getnew();
        this.A1correctbackground = this.backColor = new Color(this.redness, this.greenness, this.blueness);
        this.lambdacorrectbackground = this.backColor;
        this.Tcorrectbackground = this.backColor;
        this.omegacorrectbackground = this.backColor;
        this.vcorrectbackground = this.backColor;
        this.vmaxcorrectbackground = this.backColor;
    }

    public void _evolution1() {
        this.t += this.dt;
    }

    public void getnew() {
        this.resetTable();
        this.t = 0.0;
        this._view.resetTraces();
        this.A = (double)Math.round(10.0 + 10.0 * Math.random()) / 100.0;
        this.lambda = (double)Math.round(5.0 + 15.0 * Math.random()) / 10.0;
        this.T = Math.round(2.0 + 6.0 * Math.random());
        this.w = Math.PI * 2 / this.T;
        this.k = Math.PI * 2 / this.lambda;
        this.v = this.w / this.k;
        this.vmax = this.A * this.w;
    }

    public void resetTable() {
        this.showAnswerFlag = false;
        this.enterA1 = 0.0;
        this.A1correct = "  ?";
        this.A1correctbackground = this.backColor;
        this.enterlambda = 0.0;
        this.lambdacorrect = "  ?";
        this.lambdacorrectbackground = this.backColor;
        this.enterT = 0.0;
        this.Tcorrect = "  ?";
        this.Tcorrectbackground = this.backColor;
        this.enteromega = 0.0;
        this.omegacorrect = "  ?";
        this.omegacorrectbackground = this.backColor;
        this.enterv = 0.0;
        this.vcorrect = "  ?";
        this.vcorrectbackground = this.backColor;
        this.entervmax = 0.0;
        this.vmaxcorrect = "  ?";
        this.vmaxcorrectbackground = this.backColor;
    }

    public void _method_for_getnewwave_action() {
        this._simulation.disableLoop();
        this.getnew();
        this._simulation.enableLoop();
    }

    public void _method_for_xcoordinate_dragaction() {
        this._simulation.disableLoop();
        this._view.resetTraces();
        this._simulation.enableLoop();
    }

    public void _method_for_xcoordinate2_dragaction() {
        this._simulation.disableLoop();
        this._view.resetTraces();
        this._simulation.enableLoop();
    }

    public void _method_for_playpause_actionOn() {
        this._simulation.disableLoop();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_playpause_actionOff() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_Check_action() {
        this._simulation.disableLoop();
        if (!this.showAnswerFlag) {
            if (Math.abs(this.A - this.enterA1) < 0.01) {
                this.A1correct = "  Yes";
                this.A1correctbackground = Color.GREEN;
            } else {
                this.A1correct = "  No";
                this.A1correctbackground = Color.RED;
            }
            if (Math.abs(this.lambda - this.enterlambda) < 0.1) {
                this.lambdacorrect = "  Yes";
                this.lambdacorrectbackground = Color.GREEN;
            } else {
                this.lambdacorrect = "  No";
                this.lambdacorrectbackground = Color.RED;
            }
            if (Math.abs(this.T - this.enterT) < 0.1) {
                this.Tcorrect = "  Yes";
                this.Tcorrectbackground = Color.GREEN;
            } else {
                this.Tcorrect = "  No";
                this.Tcorrectbackground = Color.RED;
            }
            if (Math.abs(this.w - this.enteromega) < 0.02) {
                this.omegacorrect = "  Yes";
                this.omegacorrectbackground = Color.GREEN;
            } else {
                this.omegacorrect = "  No";
                this.omegacorrectbackground = Color.RED;
            }
            if (Math.abs(this.v - this.enterv) < 0.04) {
                this.vcorrect = "  Yes";
                this.vcorrectbackground = Color.GREEN;
            } else {
                this.vcorrect = "  No";
                this.vcorrectbackground = Color.RED;
            }
            if (Math.abs(this.vmax - this.entervmax) < 0.01) {
                this.vmaxcorrect = "  Yes";
                this.vmaxcorrectbackground = Color.GREEN;
            } else {
                this.vmaxcorrect = "  No";
                this.vmaxcorrectbackground = Color.RED;
            }
        }
        this._simulation.enableLoop();
    }

    public void _method_for_Show_action() {
        this._simulation.disableLoop();
        this.showAnswerFlag = true;
        this.enterA1 = this.A;
        this.enterlambda = this.lambda;
        this.enterT = this.T;
        this.enteromega = this.w;
        this.enterv = this.v;
        this.entervmax = this.vmax;
        this._simulation.enableLoop();
    }

    public void _method_for_reset_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    public void _method_for_instructions_action() {
        this._simulation.disableLoop();
        if (this.helpFlag) {
            this.helpFlag = false;
            this.helpLabel = "Show Help";
        } else {
            this.helpFlag = true;
            this.helpLabel = "Hide Help";
        }
        this._simulation.enableLoop();
    }

    public double _method_for_point_y() {
        return this.A * Math.sin(this.w * this.t - this.k * this.xval);
    }

    public double _method_for_point2_y() {
        return this.A * Math.sin(this.w * this.t - this.k * this.xval2);
    }

    public double _method_for_timetrace_y() {
        return this.A * Math.sin(this.w * this.t - this.k * this.xval);
    }

    public double _method_for_timetrace2_y() {
        return this.A * Math.sin(this.w * this.t - this.k * this.xval2);
    }

    public void _method_for_helpBox_onClosing() {
        this._simulation.disableLoop();
        this.helpFlag = false;
        this.helpLabel = "Show Help";
        this._simulation.enableLoop();
    }

    @Override
    public synchronized void reset() {
        this.A = 0.1;
        this.w = 1.0;
        this.lambda = 1.0;
        this.k = Math.PI * 2 / this.lambda;
        this.xval = 0.0;
        this.xval2 = 1.0;
        this.T = 0.0;
        this.v = 0.0;
        this.vmax = 0.0;
        this.t = 0.0;
        this.dt = 0.05;
        this.helpFlag = false;
        this.helpLabel = "Show Help";
        this.showAnswerFlag = false;
        this.enterA1 = 0.0;
        this.A1correct = "  ?";
        this.enterlambda = 0.0;
        this.lambdacorrect = "  ?";
        this.enterT = 0.0;
        this.Tcorrect = "  ?";
        this.enteromega = 0.0;
        this.omegacorrect = "  ?";
        this.enterv = 0.0;
        this.vcorrect = "  ?";
        this.entervmax = 0.0;
        this.vmaxcorrect = "  ?";
        this.redness = 200;
        this.greenness = 220;
        this.blueness = 208;
    }

    @Override
    public synchronized void initialize() {
        this._initialization1();
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
        this._evolution1();
    }

    @Override
    public synchronized void update() {
    }

    @Override
    public void _freeMemory() {
        System.gc();
    }
}

