#############################
### Factor analysis ###
#############################

# First install and load package psych
library(psych)

#######################
### Import the data ###
#######################

food <- read.csv("C:/Users/loukia/Desktop/multivariate/Labs/Lab3_R_FA/food.csv")

###################################
### Descriptive characteristics ###
###################################
round(cbind(colMeans(food),apply(food,2,sd)),2)

############################
### Examine correlations ###
############################
# Correlation plot
pairs(food)

# Correlation matrix
print(cor(food),2)

# KMO
KMO(food)

# Testing correlations
cortest.bartlett(food)

###########################################
### Fitting MLE model (default options) ###
###########################################
food.fa <- factanal(food, factors = 2)
food.fa

# uniquenesses
food.fa$uniquenesses

# communality
rowSums(food.fa$loadings^2)

1 - rowSums(food.fa$loadings^2) # uniqueness

# The residual matrix
Lambda <- food.fa$loadings
Lambda
Psi <- diag(food.fa$uniquenesses)
Psi
R <- food.fa$correlation
Rhat <- Lambda %*% t(Lambda) + Psi
round(R - Rhat, 6)

# Interpretation of the factors
food.fa.none <- factanal(food, factors = 2, rotation = "none")
food.fa.varimax <- factanal(food, factors = 2, rotation = "varimax")
food.fa.promax <- factanal(food, factors = 2, rotation = "promax")

par(mfrow = c(1,3))
plot(food.fa.none$loadings[,1], 
     food.fa.none$loadings[,2],
     xlab = "Factor 1", 
     ylab = "Factor 2", 
     ylim = c(-1,1),
     xlim = c(-1,1),
     main = "No rotation")
abline(h = 0, v = 0)

plot(food.fa.varimax$loadings[,1], 
     food.fa.varimax$loadings[,2],
     xlab = "Factor 1", 
     ylab = "Factor 2", 
     ylim = c(-1,1),
     xlim = c(-1,1),
     main = "Varimax rotation")

text(food.fa.varimax$loadings[,1]-0.08, 
     food.fa.varimax$loadings[,2]+0.08,
     colnames(food),
     col="blue")
abline(h = 0, v = 0)

plot(food.fa.promax$loadings[,1], 
     food.fa.promax$loadings[,2],
     xlab = "Factor 1", 
     ylab = "Factor 2",
     ylim = c(-1,1),
     xlim = c(-1,1),
     main = "Promax rotation")
abline(h = 0, v = 0)

#####################################
### FA using principal components ###
#####################################

# Factor analysis using principal component method
fitPCA <- principal(food,nfactors = 2,covar = F,rotate = "none")
fitPCA

rowSums(fitPCA$loadings[,1:2]^2)

# Eigenvalue-vector decomposition of the correlation matrix
eigCor <- eigen(cor(food))
round(cumsum(eigCor$values/sum(eigCor$values))*100,2)
round(t(sqrt(eigCor$values)*t(eigCor$vectors)),2)[,1:2]

# Factor analysis using principal component method
fitPCA <- principal(food,nfactors = 2,covar = F,rotate = "varimax")
fitPCA

# Compare results with the MLE
par(mfrow = c(1,2))
plot(food.fa.varimax$loadings[,1], 
     food.fa.varimax$loadings[,2],
     xlab = "Factor 1", 
     ylab = "Factor 2", 
     ylim = c(-1,1),
     xlim = c(-1,1),
     main = "Varimax rotation - MLE")

text(food.fa.varimax$loadings[,1]-0.08, 
     food.fa.varimax$loadings[,2]+0.08,
     colnames(food),
     col="blue")
abline(h = 0, v = 0)

plot(fitPCA$loadings[,1], 
     fitPCA$loadings[,2],
     xlab = "Factor 1", 
     ylab = "Factor 2", 
     ylim = c(-1,1),
     xlim = c(-1,1),
     main = "Varimax rotation - PCA")

text(fitPCA$loadings[,1]-0.08, 
     fitPCA$loadings[,2]+0.08,
     colnames(food),
     col="blue")
abline(h = 0, v = 0)


# Factor scores
colMeans(fitPCA$scores)
cov(fitPCA$scores)

scale(food) %*% ( solve(cor(food)) %*% fitPCA$loadings[,1:2]  )
