# Basic Algebra
a=3
b=6
a+b
b-a
a*b
b/a
abs(a-b)
a^2
a^(-2)
b^(1/2)
b^(-1/3)
sqrt(b)
x=3
logx=log(x)
exp(logx)

# Vectors
x=c(1,2,3,-4)
x[3]
sum(x)
y=c(5,-6,7,8)
y[2:3]
n=length(y)
n
t(x)     # transpose
x*y      # element by element
x%*%y    # the result is scalar
x%*%t(y) # the result is matrix
x^2
x%*%x
1/y
x=rep(0,10)
x
for (i in 1:10) x[i]=10*i
x
x[c(1,5,7)]
y=1:4
y
i=rep(2,4)
i
x=rep(y,2)
x
z=rep(y,i)
z
w=rep(y,y)
w


# Matrices
A=rbind(c(1,2,3),c(4,5,6))
A
A[,1]
B=cbind(c(1,3),c(2,4))
B
B[1,]
A1=rbind(c(5,6,7),c(-5,-6,-7))
A-A1
B%*%A      # matrix multiplication
B^2        # elements to the power
B%*%B      # matrix multiplication
t(A)       # transpose
B^(-1)     # elements to the power
det(B)     # determinant
C=matrix(c(16,7,3,21),2,2)
eigen(C)   # eigenvalues and eigenvectors
solve(C)   # inverse
x=1:20
A=matrix(x,4,5)
A
B=matrix(x,4,5,byrow=T)
B
C=B[2:3,3:5]
C

# Example
S=cbind(c(1,2),c(2,5)) # covariance matrix (symmetric and positive semi-definite
res=eigen(S)
res
T=res$vectors
L=diag(res$values)
T%*%L%*%t(T) # equal to S, T: the columns of T are the eigenvectors, 
         # L: diagonal matrix, the diagonal elements are the eigenvalues 
S^(1/2)
S^(1/2)*S^(1/2) # equal to S


##########################################################################

# Loops

X=rep(0,10)
for (i in 1:10) X[i]=2*i+3
X

Y=0
while (Y[length(Y)]<100) {
    j=Y[length(Y)]
    Y=c(Y, 2*j+1)
}
Y      

##########################################################################

# Simulate n draws from the Normal distribution with mean equal to mu
# and standard deviation equal to sd
n=100
mu=0
sd=1
x=rnorm(n,mu,sd)
mean(x)     # sample mean
var(x)      # sample variance
n=10000
mu=10
sd=3
x=rnorm(n,mu,sd)
hist(x)

y=3
mu=4
sd=1
dnorm(y,mu,sd)    # density
pnorm(y,mu,sd)    # distribution function
qnorm(0.95,mu,sd) # quantile function
qnorm(0.975,0,1)

# Statistical Inference
n=100
mu=5
sd=2
x=rnorm(n,mu,sd)
x_bar=mean(x)
x_var=var(x)
xbar_se=sqrt(x_var/n)
# Confidence Interval
CI=c(x_bar-xbar_se*qt(0.975,n-1),x_bar+xbar_se*qt(0.975,n-1))
CI
# H0: mu=4.8, H1: mu>4.8
mu=4.8
T=(x_bar-mu)/xbar_se  # test statistic
t0=qt(0.95,n-1)       # critical value
T>t0
pvalue=1-pt(T,n-1) 
pvalue 

# Simulate n draws from the Bivariate Normal distribution with mean equal to mu
# and covariance matrix equal to Sigma

# First, you need to load MASS Package

# Example 1: rho=0.5
n=100
mu=c(5,4)
Sigma=cbind(c(4,3),c(3,9))   
X=mvrnorm(n, mu, Sigma)
X_bar=apply(X,2,mean)
X_bar
X_cov=cov(X)
X_cov
cor(X)
plot(X[,1],X[,2])

# Example 2: rho=0.9
n=100
mu=c(5,4)
Sigma=cbind(c(4,5.4),c(5.4,9))   
X=mvrnorm(n, mu, Sigma)
X_bar=apply(X,2,mean)
X_bar
X_cov=cov(X)
X_cov
cor(X)
plot(X[,1],X[,2])

# Example 3: rho=-0.9
n=100
mu=c(5,4)
Sigma=cbind(c(4,-5.4),c(5.-4,9))   
X=mvrnorm(n, mu, Sigma)
X_bar=apply(X,2,mean)
X_bar
X_cov=cov(X)
X_cov
cor(X)
plot(X[,1],X[,2])

##############################################################################

# A function that calculates the logarithm of the pdf of a normal distribution
"logdnorm" <-
function (x,mu,sd) 
{
logfx=-0.5*log(2*pi)-log(sd)-0.5*((x-mu)/sd)^2

return(logfx)
}

# Run the function
y=3
mu=4
sd=1
dnorm(y,mu,sd)
logfx=logdnorm(y,mu,sd)
exp(logfx)

############################################################################

####################
### College data ###
####################
college <- read.csv("C:/Users/loukia/Desktop/multivariate/Labs/Lab1_R_Intro/college.csv")
names(college) <- c("id","School Type","SAT","Acceptance","$/Student","Top 10%","%PhD","Grad %")

# Matrix plots
pairs(college[,-c(1:2)],cex.labels = 1.2,cex.axis = 1.2)
pairs(college[,-c(1:2)],cex.labels = 1.2,cex.axis = 1.2,upper.panel = NULL)

# Mean of each variable
colMeans(college[,-c(1:2)])

# Median of each variable
apply(college[,-c(1:2)],2,median)

# SD of each variable
apply(college[,-c(1:2)],2,sd)

# Covariance matrix
cov(college[,-c(1:2)])

# Correlation matrix
cor(college[,-c(1:2)])

# Relationship between covariance and correlation matrix
xx <- college[,-c(1:2)]
D <- diag(diag(cov(xx))^(-1/2))
D %*% cov(xx) %*% D
cor(xx)



