"gibbs2" <-
function (data,a1=0.5,a2=0.5,c1=1,d1=1,c2=1,d2=1,nburn=0,ndraw=1000) 
{

#Gibbs sampling for Poisson change point problem

n <- length(data)
sum1 <- c1 + a1
sum2 <- c2 + a2
sumy <- sum(data)

p <- numeric(n-1)

#initial values:drawn from prior

b1 <- rgamma(1,c1,1)/d1
b2 <- rgamma(1,c2,1)/d2
theta <- rgamma(1,a1,1)/b1
lambda <- rgamma(1,a2,1)/b2
k <- sample(c(1:(n-1)),size=1)

# create matrix to record draws:

draws <- matrix(ncol=5,nrow=ndraw)


# MCMC LOOP FOLLOWS:

it <- -nburn
while(it < ndraw){ it <- it+1;

sumyk <- sum(data[c(1:k)])

# draw theta:
theta <- rgamma(1,a1+sumyk,1)/(b1+k)

# draw lambda:
lambda <- rgamma(1,a2+sumy-sumyk,1)/(b2+n-k)

# draw b1:
b1 <- rgamma(1,sum1,1)/(d1+theta)

# draw b2:
b2 <- rgamma(1,sum2,1)/(d2+lambda)

# draw k:
# first create the vector of probabilities:
aux1 <- lambda-theta
for(j in 1:(n-1)){ 
sumy1j <- sum(data[c(1:j)])
sumy2j=sumy-sumy1j
p[j] <- (exp(aux1*j))*(theta**sumy1j)*(lambda**sumy2j)
}
p <- p/sum(p)
# now sample k according to probabilities p:
k <- sample(c(1:(n-1)),size=1,prob=p)

# after burn-in record draws:
if (it>0){
draws[it,1] <- theta
draws[it,2] <- lambda
draws[it,3] <- b1
draws[it,4] <- b2
draws[it,5] <- k
}

}

# END MCMC LOOP

return(draws)

}
