"gibbs" <-
function (data,mu0=0,kappa0=0.1,alpha0=0.1,lambda0=0.1,nburn=0,ndraw=5000) 
{

#Gibbs sampling for model:
#indep observ from N(mu,1/omega)
#pi(mu,omega)=N(mu|mu0,1/kappa0)Gamma(omega|alpha0,lambda0)

n <- length(data)
sumy <- sum(data)
alpha1 <- alpha0 + (n/2)

#initial values:drawn from prior

mu <- rnorm(1,mu0,sqrt(1/kappa0))
omega <- rgamma(1,alpha0,1)/lambda0

# matrix that will contain recorded draws:

draws <- matrix(ncol=2,nrow=ndraw)

# MCMC LOOP FOLLOWS:

it <- -nburn
while(it < ndraw){ it <- it+1;

# draw mu:
var <- 1/(kappa0+omega*n)
mu1 <- (kappa0*mu0 + omega*sumy)*var
mu <- rnorm(1,mu1,sqrt(var))

# draw omega:
omega <- rgamma(1,alpha1,1)/(lambda0 + (sum((data - mu)^2))/2 )

# after burn-in record mu and omega:
if(it>0){
draws[it,1] <- mu
draws[it,2] <- omega
}

}

# END MCMC LOOP

return(draws)

}
