# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
# Bayesian Statistics
# Exercise 5.8
# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

# Consider a sample x1, ..., xn, consisting of independent draws from a Poisson
# random variable with mean θ. Consider the hypothesis test, with Null hypothesis
# H0: θ = 1, against an alternative hypothesis H1: θ != 1. Assume a prior
# probability of 0.95 for H0 and a Gamma(p,q) prior for θ under H1.

# a. Calculate the posterior probability of H0.

post_H0 <- function(n, s, p, prior_H0 = 0.95) {
  
  # In general, p and q are free, but in this exercise, p = 2q.
  q <- p / 2
  
  # a = P(x, H0) = P(x|H0) * P(H0)
  a <- prior_H0 * exp(- n)
  
  # b = P(x, H1) = P(x|H1) * P(H1)
  b <- (1 - prior_H0) * q ^ p * gamma(s + p) / (gamma(p) * (n + q) ^ (s + p))
  
  # Result
  a / (a + b)
  
} 

# b. Assume n = 10, sum of xi = 20, and p = 2q. What is the posterior
# probability of H0 for each of p = 2, 1, 0.5, 0.1? What happens to this
# posterior probability as p -> 0?

post_H0(10, 20, 2)
post_H0(10, 20, 1)
post_H0(10, 20, 0.5)

# Limiting behavior of posterior as p -> 0.
m <- 100
p <- seq(1, 1e-7, length = m)
y <- rep(0, m)

for (i in 1:m) {
  y[i] <- post_H0(10, 20, p[i])
}

# Text
options(digits = 10)
cat("For p = ", p[m], ", P(H0 | x) = ", y[m], sep = "")

# Plot
plot(x = p, y = y, type = "l",
     main = "Limiting behavior of posterior P(H0 | x) as p -> 0",
     ylab = "P(H0 | x)", xlab = "p")




