library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
--use IEEE.NUMERIC_STD.ALL;

-- Uncomment the following library declaration if instantiating
-- any Xilinx leaf cells in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity test_tb is
--  Port ( );
end test_tb;

architecture Behavioral of test_tb is

component test is
Port (
a, b: in std_logic;
clk: in std_logic;
reset: in std_logic;
q3: out std_logic  );
end component;

signal a, b:  std_logic;
signal clk, reset:   std_logic;
signal q3:    std_logic; 

constant CLK_period : time := 10.000 ns;

begin

uut: test port map (a,b,clk, reset, q3);


CLK_process : process
    begin
		CLK <= '0';
		wait for clk_period/2;
		CLK <= '1';
		wait for clk_period/2;
end process CLK_process;


test_proc: process is

begin

-- 	Synchronous RESET is deasserted on CLK falling edge 
-- after GSR signal disable (it remains enabled for 100 ns)
RESET <= '1';
wait for 100 ns;
wait until (CLK = '0' and CLK'event);
RESET <= '0';

a<='0';b<='0';wait for 10ns;
assert q3='1' report "q3 has a value of 1";
a<='1';b<='1';wait for 10ns;
assert false report "Value of q3 is:"& std_logic'image(q3);
a<='0';b<='0';wait for 10ns;
a<='1';b<='1';wait for 10ns;
a<='0';b<='0';wait for 10ns;

end process test_proc;

end Behavioral;
