----------------------------------------------------------------------------------
-- Company: 
-- Engineer: 
-- 
-- Create Date: 11/28/2020 06:40:32 PM
-- Design Name: 
-- Module Name: ALU_tb - Behavioral
-- Project Name: 
-- Target Devices: 
-- Tool Versions: 
-- Description: 
-- 
-- Dependencies: 
-- 
-- Revision:
-- Revision 0.01 - File Created
-- Additional Comments:
-- 
----------------------------------------------------------------------------------


library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
use IEEE.NUMERIC_STD.ALL;

-- Uncomment the following library declaration if instantiating
-- any Xilinx leaf cells in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity alu2pmod_tb is
--  Port ( );
end alu2pmod_tb;

architecture Behavioral of alu2pmod_tb is

component alu2pmod is
  Port ( 
        a                    : in  std_logic_vector(2 downto 0);
        b                    : in  std_logic_vector(2 downto 0);
        ctr                  : in  std_logic;
        digit_selection_in   : in  std_logic;
        result               : out std_logic_vector(3 downto 0);
        seven_segment        : out std_logic_vector(6 downto 0);
        digit_selection_out  : out std_logic
        );
end component alu2pmod;


signal a_tb                    : std_logic_vector(2 downto 0);
signal b_tb                    : std_logic_vector(2 downto 0);
signal ctr_tb                  : std_logic:='0';                   
signal digit_selection_in_tb   : std_logic;                                 
signal result_tb               : std_logic_vector(3 downto 0);
signal seven_segment_tb        : std_logic_vector(6 downto 0);
signal digit_selection_out_tb  : std_logic;                    
                
       
begin

-- Two valid ways to map ports to internal signals

--    Vertion 1 of declaring a port map
    uut: alu2pmod port map ( 
                                a=>a_tb, 
                                b=>b_tb, 
                                ctr=>ctr_tb, 
                                digit_selection_in=>digit_selection_in_tb,
                                result=>result_tb, 
                                seven_segment=>seven_segment_tb, 
                                digit_selection_out=>digit_selection_out_tb);


--    Vertion 2 of declaring a port map
--	  uut: ALU port map (a_tb,b_tb,ctr_tb, digit_selection_in_tb, result_tb, seven_segment_tb, digit_selection_out_tb);


-- TEST CODE

------------------------------------------------------
-- Version 1: test all combinations, EXCEPT digit_selection_in
--

--test_1: process is
--begin

--ctr_tb<= not ctr_tb;
--for i in 0  to 3 loop
--    a_tb<=std_logic_vector(to_unsigned(i,a_tb'length));
--    for j in 0 to 3 loop
--        b_tb<=std_logic_vector(to_unsigned(j,a_tb'length));wait for 10ns;
--    end loop ;
--end loop ;    

--end process test_1;

------------------------------------------------------
-- Version 2: Version 1 plus procedure (dummy one as no parameters are used in procedure's declaration part) 

--test_2: process is
   
--procedure sim_test (a: in integer; b: in integer; ctr: in std_logic)  is    --a,b, ctr are implied to be VARIABLES (not signals)
--begin
--for i in 0 to a loop
--    a_tb<=std_logic_vector(to_unsigned(i,a_tb'length));
--    for j in 0 to b loop
--        b_tb<=std_logic_vector(to_unsigned(j,a_tb'length));wait for 10ns;
--    end loop j;
--end loop i;  
--end procedure sim_test;

--begin

--sim_test(a_tb'length**2-1, b_tb'length**2-1,'0');
--sim_test(a_tb'length**2-1, b_tb'length**2-1,'1');

--end process test_2;

test_3: process is
   
begin

ctr_tb<='1';
a_tb<="100";b_tb<="011";wait for 20ns;
a_tb<="100";b_tb<="100";wait for 20ns;
ctr_tb<='0';
a_tb<="000";b_tb<="011";wait for 20ns;
a_tb<="010";b_tb<="100";wait for 20ns;
a_tb<="100";b_tb<="100";wait for 20ns;
a_tb<="111";b_tb<="100";wait for 20ns;

end process test_3;

end architecture Behavioral;
