----------------------------------------------------------------------------------
-- Company: 
-- Engineer: 
-- 
-- Create Date: 12/04/2022 07:43:04 PM
-- Design Name: 
-- Module Name: alu2bcd - Behavioral
-- Project Name: 
-- Target Devices: 
-- Tool Versions: 
-- Description: 
-- 
-- Dependencies: 
-- 
-- Revision:
-- Revision 0.01 - File Created
-- Additional Comments:
-- 
----------------------------------------------------------------------------------


library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
use IEEE.NUMERIC_STD.ALL;

-- Uncomment the following library declaration if instantiating
-- any Xilinx leaf cells in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity alu2pmod is
  Port ( 
        a                    : in  std_logic_vector(2 downto 0);
        b                    : in  std_logic_vector(2 downto 0);
        ctr                  : in  std_logic;
        digit_selection_in   : in  std_logic;
        result               : out std_logic_vector(3 downto 0);
        seven_segment        : out std_logic_vector(6 downto 0);
        digit_selection_out  : out std_logic
        );
end entity alu2pmod;

-- Fill with your own code

architecture Dataflow of alu2pmod is

signal result_temp: unsigned(3 downto 0);

begin

result_temp<=unsigned('0'&a)+ unsigned('0'&b) when ctr='1' else unsigned(a&'0') when ctr='0' else (others=>'0');
result<=std_logic_vector(result_temp);

with result_temp select
seven_segment<="0111111" when "0000", --0
               "0000110" when "0001", --1
               "1011011" when "0010", --2
               "1001111" when "0011", --3
               "1100110" when "0100", --4
               "1101101" when "0101", --5
               "1111101" when "0110", --6
               "0000111" when "0111", --7
               "1111111" when "1000", --8
               "1101111" when "1001", --9
               "1000000" when others;

-- BEHAVIORAL EDITION

--values: process (result_temp) begin

--case result_temp is

--    when X"0" => seven_segment   <="0111111";    -- 0
--    when X"1" => seven_segment   <="0000110";    -- 1
--    when X"2" => seven_segment   <="1011011";    -- 2
--    when X"3" => seven_segment   <="1001111";    -- 3
--    when X"4" => seven_segment   <="1100110";    -- 4
--    when X"5" => seven_segment   <="1101101";    -- 5
--    when X"6" => seven_segment   <="1111101";    -- 6
--    when X"7" => seven_segment   <="0000111";    -- 7
--    when X"8" => seven_segment   <="1111111";    -- 8
--    when X"9" => seven_segment   <="1101111";    -- 9
--    when others => seven_segment <="0000000";
    
    
--end case;

--end process values;
               
digit_selection_out<=digit_selection_in;


end architecture Dataflow;

