library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
use IEEE.NUMERIC_STD.ALL;


entity Lecture_6_tb is
--  Port ( );
end Lecture_6_tb;

architecture Behavioral of Lecture_6_tb is

component Lecture_6 is
port (I1: in bit;
      O1: out bit);
end component Lecture_6;

-- Internal signals 

signal i,o   : bit;

begin 

uut: lecture_6 port map(I1=>i,O1=>o);


applytest: process
begin
    i<='0'; wait for 20ns;
    i<='1'; wait for 20ns;
    
end process;

end Behavioral;

library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.numeric_std.all;

entity lect_6a_tb is
--  Port ( );
end lect_6a_tb;


architecture Behavioral of lect_6a_tb is

component lect_6a port 
( 
            signal1_in   : in STD_LOGIC_VECTOR(3 downto 0);
            signal2_in   : in STD_LOGIC_VECTOR (3 downto 0);
            signal1_out  : out STD_LOGIC_VECTOR(7 downto 0);
            signal2_out  : out STD_LOGIC_VECTOR (3 downto 0)
);
end component;

signal      signal1_in_tb:STD_LOGIC_VECTOR(3 downto 0); 
signal      signal2_in_tb:STD_LOGIC_VECTOR (3 downto 0);        
signal      signal1_out_tb  :  STD_LOGIC_VECTOR(7 downto 0);
signal      signal2_out_tb  :  STD_LOGIC_VECTOR (3 downto 0);       


begin

uut: lect_6a port map (signal1_in=>signal1_in_tb, signal2_in=>signal2_in_tb, signal1_out=>signal1_out_tb, signal2_out=>signal2_out_tb); 


tb: process is

begin 

--A with Part A and Part B
signal1_in_tb<="0011";signal2_in_tb<="1100";
wait for 20 ns;

end process tb;

end architecture Behavioral;


library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.numeric_std.all;

entity lect_6b_tb is
--  Port ( );
end lect_6b_tb;


architecture Behavioral of lect_6b_tb is

component lect_6b port 
( 
            signal1_in  : in STD_LOGIC_VECTOR(3 downto 0);
            signal2_in  : in unsigned (3 downto 0);
            signal3_in  : in signed (3 downto 0);
            signal4_in  : in integer range -16 to 15;
            signal1_out  : out STD_LOGIC_VECTOR(3 downto 0);
            signal2_out  : out unsigned (3 downto 0);
            signal3_out  : out signed (3 downto 0);
            signal4_out  : out integer range -16 to 15
);
end component;

signal      signal1_in_tb:STD_LOGIC_VECTOR(3 downto 0); 
signal      signal2_in_tb:unsigned (3 downto 0);        
signal      signal3_in_tb:signed (3 downto 0);          
signal      signal4_in_tb:  integer range -16 to 15;      
signal      signal1_out_tb  :  STD_LOGIC_VECTOR(3 downto 0);
signal      signal2_out_tb  :  unsigned (3 downto 0);       
signal      signal3_out_tb  :  signed (3 downto 0);         
signal      signal4_out_tb  :  integer range -16 to 15;      


begin

uut: lect_6b port map (signal1_in=>signal1_in_tb, signal2_in=>signal2_in_tb,signal3_in=>signal3_in_tb, signal4_in=>signal4_in_tb,  
                            signal1_out=>signal1_out_tb, signal2_out=>signal2_out_tb, signal3_out=>signal3_out_tb, signal4_out=>signal4_out_tb); 


tb: process is

begin 

--A with Part A and Part B
signal1_in_tb<="0011";signal2_in_tb<="1100";signal3_in_tb<="1100";signal4_in_tb<=-8;
wait for 20 ns;

end process tb;

end architecture Behavioral;

library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
use IEEE.NUMERIC_STD.ALL;


entity lect_6c_tb is
--  Port ( );
end lect_6c_tb;

architecture Behavioral of lect_6c_tb is

component lect_6c 
port ( 
signal a,b  : in std_logic_vector(2 downto 0);
signal f:   in  unsigned (1 downto 0);
signal c    : out std_logic_vector(5 downto 0);
signal d:  out signed (1 downto 0);
signal e    : out integer range 0 to 15
);

end component;

-- Internal signals 

signal a1, b1   : std_logic_vector(2 downto 0):="111"; --Port map signals
signal f1       : unsigned (1 downto 0);
signal c1       : std_logic_vector(5 downto 0);

signal f, g, h  : std_logic_vector(2 downto 0); --For the shake of the tests
signal d1    : signed (1 downto 0);
signal e1 : integer  range 0 to 15;

begin 

uut: lect_6c port map(a=>a1,b=>b1, f=>f1 ,c=>c1, d=>d1, e=>e1);

-- Scenario 1

--applytest: process
--begin
--    a1<="000";b1<="100";
--    wait;                   -- if No wait -> Does not stop
--end process;

 -- Scenario 2
applytest: process
begin
    a1<="100";
--    b1<="001";
--    f1<="10";
--    wait for 5 ns;
--    a1<="111";
--    b1<="001";
--    f1<="10";
--    wait for 5 ns;
--    a1<="011";
    b1<="001";
    f1<="10";
    wait for 5 ns;
end process;

end Behavioral;

library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
use IEEE.NUMERIC_STD.ALL;


entity lect_6d_tb is
--  Port ( );
end lect_6d_tb;

-- FIRST CASE: STD_LOGIC EDITION
architecture Behavioral of lect_6d_tb is

component lect_6d is
port (
signal a: in  std_logic_vector(4 downto 0);
signal b: in  std_logic_vector(4 downto 0);
signal c: out std_logic_vector(4 downto 0);
signal d: out std_logic_vector(4 downto 0);
signal e: out integer range 0 to 15
);
end component lect_6d;


-- Internal signals 

signal a1, b1   : std_logic_vector(4 downto 0); --Port map signals
signal c1       : std_logic_vector(4 downto 0);
signal d1       : std_logic_vector (4 downto 0);
signal e1       : integer range 0 to 15;
signal f, g, h  : std_logic_vector(2 downto 0); --For the shake of the tests


begin 

uut: lect_6d port map(a=>a1,b=>b1,c=>c1, d=>d1, e=>e1);

 -- No wait - Does not stop
applytest: process
begin
   a1<="11100";b1<="00111";
   wait;
end process;

end Behavioral;

-- SECOND CASE: UNSIGNED EDITION
--architecture Behavioral of lect_6d_tb is

--component lect_6d is
--port (
--signal a: in  unsigned(4 downto 0);
--signal b: in  unsigned(4 downto 0);
--signal c: out unsigned(4 downto 0);
--signal d: out unsigned(4 downto 0);
--signal e: out integer range 0 to 15
--);
--end component lect_6d;


---- Internal signals 

--signal a1, b1   : unsigned(4 downto 0); --Port map signals
--signal c1       : unsigned(4 downto 0);
--signal d1       : unsigned (4 downto 0);
--signal e1       : integer range 0 to 15;
--signal f, g, h  : unsigned(2 downto 0); --For the shake of the tests


--begin 

--uut: lect_6d port map(a=>a1,b=>b1,c=>c1, d=>d1, e=>e1);

-- -- No wait - Does not stop
--applytest: process
--begin
--   a1<="11100";b1<="00111";
--   wait;
--end process;

--end Behavioral;

-- THIRD CASE: SIGNED EDITION
architecture Behavioral of lect_6d_tb is

component lect_6d is
port (
signal a: in  signed(4 downto 0);
signal b: in  signed(4 downto 0);
signal c: out signed(4 downto 0);
signal d: out signed(4 downto 0);
signal e: out integer range 0 to 15
);
end component lect_6d;


-- Internal signals 

signal a1, b1   : signed(4 downto 0); --Port map signals
signal c1       : signed(4 downto 0);
signal d1       : signed (4 downto 0);
signal e1       : integer range 0 to 15;
signal f, g, h  : signed(2 downto 0); --For the shake of the tests


begin 

uut: lect_6d port map(a=>a1,b=>b1,c=>c1, d=>d1, e=>e1);

 -- No wait - Does not stop
applytest: process
begin
   a1<="11100";b1<="00111";
   wait;
end process;

end Behavioral;