library IEEE;
use IEEE.STD_LOGIC_1164.ALL;


entity Lecture_6 is
port (I1: in bit;
      O1: out bit);
end Lecture_6;

architecture Behavioral of Lecture_6 is

signal a : bit;
signal b : boolean;
signal c : Character;

begin

O1<=I1;
--WITHOUT package IEEE.STD_LOGIC_1164.ALL; 

a<='0';
b<=true;
c<='p';

--a<='0'; --Problem with the 2 concurrent values of a
--a<='1';
--b<=true;
--c<='p';


end Behavioral;

library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
--use IEEE.NUMERIC_STD.ALL;

-- Uncomment the following library declaration if instantiating
-- any Xilinx leaf cells in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity lect_6a is
    Port (  signal1_in   : in STD_LOGIC_VECTOR(3 downto 0);
            signal2_in   : in STD_LOGIC_VECTOR(3 downto 0); 
            signal1_out  : out STD_LOGIC_VECTOR(7 downto 0);
            signal2_out  : out STD_LOGIC_VECTOR(3 downto 0)
          );
end lect_6a;

architecture Behavioral of lect_6a is

signal signal_temp : STD_LOGIC_VECTOR(7 downto 0);

begin

-- Κάντε uncomment τις εντολές ενός Part κάθε φορά και παρατηρείστε την έξοδο στο simulation

--Part A
--signal1_out<=signal2_in & signal1_in;

--Part B
--signal1_out<=signal2_in & signal1_in;
--signal2_out<=signal1_in & signal2_in; --error

--Part C: Concatenation
--signal1_out<=signal1_in & signal2_in;
--signal2_out<=signal1_in(1 downto 0) & signal2_in(1 downto 0); 

--Part D: Partial fill + Others
--signal1_out(7 downto 4)<="0000";
--signal1_out(3 downto 0)<="XXXX";
--signal2_out<=(others=>'0');

--Part E: Observe XXXX values during simulation
signal1_out(7 downto 4)<="0000";
signal1_out(3 downto 0)<="XXXX";
signal2_out<="0001";
signal2_out<="1111";


end Behavioral;

library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.numeric_std.all;

-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
--use IEEE.NUMERIC_STD.ALL;

-- Uncomment the following library declaration if instantiating
-- any Xilinx leaf cells in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity lect_6b is
    Port (  signal1_in  : in STD_LOGIC_VECTOR(3 downto 0);
            signal2_in  : in unsigned (3 downto 0);
            signal3_in  : in signed (3 downto 0);
            signal4_in  : in integer range -16 to 15;
            signal1_out  : out STD_LOGIC_VECTOR(3 downto 0);
            signal2_out  : out unsigned (3 downto 0);
            signal3_out  : out signed (3 downto 0);
            signal4_out  : out integer range -16 to 15
          );
end lect_6b;

architecture Behavioral of lect_6b is

signal signal_temp : STD_LOGIC_VECTOR(7 downto 0);

begin

-- Κάντε uncomment τις εντολές ενός Part κάθε φορά και παρατηρείστε την έξοδο στο simulation

--A part
--signal1_out<=std_logic_vector(signal2_in);          --unsigned to std_logic_vector
------  or
-- signal1_out<=std_logic_vector(signal3_in);       --signed to std_logic_vector
--signal2_out<=unsigned(signal3_in);                  --std_logic_vector to unsigned
--signal3_out<=signed(signal2_in);                    --unsigned to sign
--signal4_out<=to_integer(signal3_in);                --signed to integer

---- B part
signal1_out<=std_logic_vector(signal2_in);                                      --unsigned to std_logic_vector
signal2_out<=(to_unsigned(signal4_in,signal2_out'length));                      --integer to unsigned
signal3_out<=to_signed(signal4_in,signal3_out'length);                          --integer to signed
signal4_out<=to_integer(signed(signal1_in));                                    --std_logic_vector to integer

end Behavioral;

-- PART B: Show type conversions, Rotations and possible errors

library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
use IEEE.NUMERIC_STD.ALL;

entity lect_6c is
port (
signal a: in  std_logic_vector(2 downto 0);
signal b: in  std_logic_vector(2 downto 0);
signal f: in  unsigned (1 downto 0);
signal c:   out std_logic_vector(5 downto 0);
signal d:  out signed (1 downto 0);
signal e    : out integer range 0 to 15
);
end lect_6c;

architecture Behavioral of lect_6c is

begin

-- Κάντε uncomment τις εντολές ενός Part κάθε φορά και παρατηρείστε την έξοδο στο simulation

-- Example 1 Right and left size differ: Error              YES

--c<=a;
--d<=signed(b);

-- Example 2 OK                                             YES

--c<=a&b;

-- Example 3 Fix different sizes                            YES
-- signed: sign bit is retained

--d<=resize(signed(b),d'length);

---- Example 4 Convert signed to Integer.
 
--e<=to_integer(signed(b));

-- Example 5 Convert signed to Integer. e size expands

--e<=to_integer(signed(a));

-- Example 6 Convert signed to Integer. e size fits

--e<=to_integer(unsigned(a));
--e<=to_integer(resize(unsigned(a),4));
--e<=6;

-- Example 7 Negative signed to unsigned. Be aware of up/bottom limits

--d<=signed(f);

--Example 8 std_logic_vector to integer                    YES
--e<=5;
--e<=35;                              --error
e<=to_integer(signed(a));           --size changes

end Behavioral;

--library IEEE;
--use IEEE.STD_LOGIC_1164.ALL;
--use IEEE.NUMERIC_STD.ALL;


-- FIRST CASE: STD_LOGIC EDITION

--entity lect_6d is
--port (
--signal a: in  std_logic_vector(4 downto 0);
--signal b: in  std_logic_vector(4 downto 0);
--signal c: out std_logic_vector(4 downto 0);
--signal d: out std_logic_vector(4 downto 0);
--signal e: out integer range 0 to 15
--);
--end lect_6d;

--architecture Behavioral of lect_6d is

--signal x,y,z,w,q,u,r,t,i,o : std_logic_vector(4 downto 0);
--signal f : std_logic_vector(4 downto 0):="11111";

--begin               

--c<=a;           --Just to make RTL Analysis-Schematic
                
----Nothing is Working in Standard VHDL
--x<=a sll 2;     --Logical Shift works
--y<=a srl 2;
--z<=a sla 2;     --Arithmetic Shift not working
--w<=a sra 2;
--q<=a rol 2;
--u<=a ror 2;
--r<=shift_left(a,2);
--t<=shift_right(a,2);
--i<=rotate_left(a,2);
--o<=rotate_right(a,2);


--end Behavioral;

library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.NUMERIC_STD.ALL;

-- SECOND CASE: UNSIGNED

entity lect_6d is
port (
signal a: in  unsigned(4 downto 0);
signal b: in  unsigned(4 downto 0);
signal c: out unsigned(4 downto 0);
signal d: out unsigned(4 downto 0);
signal e: out integer range 0 to 15
);
end lect_6d;

architecture Behavioral of lect_6d is

signal x,y,z,w,q,u,r,t,i,o : unsigned(4 downto 0);
signal f : std_logic_vector(4 downto 0):="11111";
 
begin

c<=a;           --Just to make RTL Analysis-Schematic

x<=a sll 2;     --Logical Shift works
y<=a srl 2;
z<=a sla 2;     --Arithmetic Shift not working
w<=a sra 2;
q<=a rol 2;
u<=a ror 2;
r<=shift_left(a,2);
t<=shift_right(a,2);
i<=rotate_left(a,2);
o<=rotate_right(a,2);

end Behavioral;

--library IEEE;
--use IEEE.STD_LOGIC_1164.ALL;
--use IEEE.NUMERIC_STD.ALL;

---- THIRD CASE: SIGNED

--entity lect_6d is
--port (
--signal a: in  signed(4 downto 0);
--signal b: in  signed(4 downto 0);
--signal c: out signed(4 downto 0);
--signal d: out signed(4 downto 0);
--signal e: out integer range 0 to 15
--);
--end lect_6d;

--architecture Behavioral of lect_6d is

--signal x,y,z,w,q,u,r,t,i,o : signed(4 downto 0);
--signal f : std_logic_vector(4 downto 0):="11111";
 
--begin

--c<=a;           --Just to make RTL Analysis-Schematic

--x<=a sll 2;     --Logical Shift works
--y<=a srl 2;
----z<=a sla 2;     --Arithmetic Shift not working
----w<=a sra 2;
--q<=a rol 2;
--u<=a ror 2;
--r<=shift_left(a,2);
--t<=shift_right(a,2);
--i<=rotate_left(a,2);
--o<=rotate_right(a,2);

--end Behavioral;