----------------------------------------------------------------------------------
-- Company: 
-- Engineer: 
-- 
-- Create Date: 06/12/2020 09:38:44 PM
-- Design Name: 
-- Module Name: PATTERN_FSM_TB - Behavioral
-- Project Name: 
-- Target Devices: 
-- Tool Versions: 
-- Description: 
-- 
-- Dependencies: 
-- 
-- Revision:
-- Revision 0.01 - File Created
-- Additional Comments:
-- 
----------------------------------------------------------------------------------


library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
use IEEE.NUMERIC_STD.ALL;

-- Uncomment the following library declaration if instantiating
-- any Xilinx leaf cells in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

use STD.ENV.ALL;

entity counter_TB is
--  Port ( ); is not required
end counter_TB;

architecture Behavioral of counter_TB is

-- Unit Under Test (UUT)
component Counter is
port (
      clk                   : in std_logic;
      reset                 : in std_logic;
      direction             : in std_logic;
      load                  : in std_logic;
      load_data             : in std_logic_vector(3 downto 0);
      led_result            : out std_logic_vector(3 downto 0) -- LED Result input
    );
end component Counter;

-- Internal Inputs to UUT
signal clk                   : std_logic;                    
signal reset                 : std_logic;                    
signal direction             : std_logic;
signal load                  : std_logic;     
signal load_data             :  std_logic_vector(3 downto 0);                         
signal led_result            :  std_logic_vector(3 downto 0);
              

-- Internal Outputs from UUT
signal Y     : STD_LOGIC;

-- Clock period definitions
constant CLK_period : time := 10 ns;

begin
-- Instantiate the Unit Under Test (UUT)
uut: Counter 	port map (clk, reset, direction, load, load_data, led_result);

-- Clock process definition
CLK_process : process
    begin
		CLK <= '0';
		wait for clk_period/2;
		CLK <= '1';
		wait for clk_period/2;
    end process;
   
-- Stimulus process definition
Stimulus_process: process
	begin
-- 	Syncrhonous RESET is deasserted on CLK falling edge 
-- after GSR signal disable (it remains enabled for 100 ns)
		RESET <= '1';
        wait for 100 ns;
        wait until (CLK = '0' and CLK'event);
		RESET <= '0';
		    
    wait for 200 ns;
            
-- Message and simulation end
	report "TESTS COMPLETED";
	stop(2);	
	end process;

end Behavioral;
