# ZedBoard Pin Assignments

############################
# INPUT                    #
############################

# CLK - Zedboard 100MHz oscillator
set_property -dict {PACKAGE_PIN Y9 IOSTANDARD LVCMOS33} [get_ports clk]

############################
# On-board Slide Switches  #
############################
set_property -dict {PACKAGE_PIN P16 IOSTANDARD LVCMOS33} [get_ports reset]
set_property -dict {PACKAGE_PIN H17 IOSTANDARD LVCMOS33} [get_ports load]
set_property -dict {PACKAGE_PIN M15 IOSTANDARD LVCMOS33} [get_ports direction]

set_property -dict {PACKAGE_PIN F22 IOSTANDARD LVCMOS33} [get_ports {load_data[0]}]
set_property -dict {PACKAGE_PIN G22 IOSTANDARD LVCMOS33} [get_ports {load_data[1]}]
set_property -dict {PACKAGE_PIN H22 IOSTANDARD LVCMOS33} [get_ports {load_data[2]}]
set_property -dict {PACKAGE_PIN F21 IOSTANDARD LVCMOS33} [get_ports {load_data[3]}]

############################
# OUTPUT                   #
############################

############################
# On-board LEDS  #
############################

set_property -dict {PACKAGE_PIN T22 IOSTANDARD LVCMOS33} [get_ports {led_result[0]}]
set_property -dict {PACKAGE_PIN T21 IOSTANDARD LVCMOS33} [get_ports {led_result[1]}]
set_property -dict {PACKAGE_PIN U22 IOSTANDARD LVCMOS33} [get_ports {led_result[2]}]
set_property -dict {PACKAGE_PIN U21 IOSTANDARD LVCMOS33} [get_ports {led_result[3]}]


########################################################
##ZedBoard Timing Constraints
########################################################
# define clock and period
create_clock -period 5.000 -name CLK -waveform {0.000 2.500} [get_ports clk]

