----------------------------------------------------------------------------------
-- Company: 
-- Engineer: 
-- 
-- Create Date: 10/19/2020 08:31:29 PM
-- Design Name: 
-- Module Name: buzzer_tb - Behavioral
-- Project Name: 
-- Target Devices: 
-- Tool Versions: 
-- Description: 
-- 
-- Dependencies: 
-- 
-- Revision:
-- Revision 0.01 - File Created
-- Additional Comments:
-- 
----------------------------------------------------------------------------------


library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
--use IEEE.NUMERIC_STD.ALL;

-- Uncomment the following library declaration if instantiating
-- any Xilinx leaf cells in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity buzzer_tb is

end buzzer_tb;

architecture Behavioral of buzzer_tb is

component buzzer_entity port(
above_30: in std_logic;      --1 when above, 0 when below
above_25: in std_logic;      --1 when above, 0 when below
low_level: in std_logic;     --1 when low,   0 when full
buzzer: out std_logic        --1 when rings, 0 when not
);
end component;

signal above_30_tb, above_25_tb, low_level_tb, buzzer_tb : std_logic;

begin

uut: buzzer_entity port map (above_30=>above_30_tb, above_25=>above_25_tb, low_level=>low_level_tb, buzzer=>buzzer_tb);

apply_test: process is
begin

    above_30_tb<='0';above_25_tb<='0';low_level_tb<='0';wait for 20 ns;
    above_30_tb<='0';above_25_tb<='0';low_level_tb<='1';wait for 20 ns;
    above_30_tb<='0';above_25_tb<='1';low_level_tb<='0';wait for 20 ns;
    above_30_tb<='0';above_25_tb<='1';low_level_tb<='1';wait for 20 ns;
    above_30_tb<='1';above_25_tb<='0';low_level_tb<='0';wait for 20 ns;
    above_30_tb<='1';above_25_tb<='0';low_level_tb<='1';wait for 20 ns;
    above_30_tb<='1';above_25_tb<='1';low_level_tb<='0';wait for 20 ns;
    above_30_tb<='1';above_25_tb<='1';low_level_tb<='1';wait for 20 ns;

end process apply_test;

end Behavioral;