#ifndef _PDPU_WORKER_H_
#define _PDPU_WORKER_H_

#include <stdint.h>

#define MAX_ERROR_COUNT 6       // Permited error occurancies before setting a worker DOWN

#define STATUS_UP       0       // Worker is on and operable
#define STATUS_READY    1       // Worker is ready to execute tasks
#define STATUS_RUNNING  2       // Worker is executing a task
#define STATUS_DOWN     3       // Worker is off
#define STATUS_COMPLETE 4       // Worker completed a task successfully
#define STATUS_ERROR    5       // Worker terminated a task with errors

typedef struct {
	char *name;                 // Executables name
	char *dir;                  // Executables directory (including name)
	int id;                     // Unique ID for IPC
	int fd[2];                  // Pipe descriptor
	char *args[8];              // <name> <arg1> <arg2> ... <NULL>
	uint8_t status;             // Worker status
	int error_cnt;              // Error occurance counter
} worker_t;

#endif
