library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.NUMERIC_STD.ALL;

entity dummy_top_tb is
end dummy_top_tb;

architecture Behavioral of dummy_top_tb is
        constant C_PERIOD    : time      := 10 ns;
        
        -- control signals
        signal aclk          : std_logic := '0';
        signal aresetn       : std_logic := '0'; 
        
        -- AXI4 Lite interface
        signal m_axi_awaddr  : std_logic_vector(3 downto 0)  := (others=>'0');
        signal m_axi_awprot	 : std_logic_vector(2 downto 0)  := (others=>'0');
        signal m_axi_awvalid : std_logic                     := '0';
        signal m_axi_awready : std_logic;
        
        signal m_axi_wdata	 : std_logic_vector(31 downto 0) := (others=>'0');
        signal m_axi_wstrb	 : std_logic_vector(3 downto 0)  := x"f";
        signal m_axi_wvalid	 : std_logic                     := '0';
        signal m_axi_wready	 : std_logic;
        
        signal m_axi_bresp 	 : std_logic_vector(1 downto 0);
        signal m_axi_bvalid  : std_logic;
        signal m_axi_bready	 : std_logic                     := '1';
        
        signal m_axi_araddr	 : std_logic_vector(3 downto 0)  := (others=>'0');
        signal m_axi_arprot	 : std_logic_vector(2 downto 0)  := (others=>'0');
        signal m_axi_arvalid : std_logic                     := '0';
        signal m_axi_arready : std_logic;
        
        signal m_axi_rdata	 : std_logic_vector(31 downto 0);
        signal m_axi_rresp 	 : std_logic_vector(1 downto 0);
        signal m_axi_rvalid	 : std_logic;
        signal m_axi_rready	 : std_logic                     := '1';      
          
        -- AXI Stream interface signals
        signal s_tready  : std_logic                         := '1'; 
        signal s_tdata   : std_logic_vector(31 downto 0)     := (others=>'0');
        signal s_tlast   : std_logic                         := '0';
        signal s_tvalid  : std_logic                         := '0'; 
        
        signal m_tready  : std_logic                         := '0'; 
        signal m_tdata   : std_logic_vector(31 downto 0)     := (others=>'0');
        signal m_tlast   : std_logic                         := '0';
        signal m_tvalid  : std_logic                         := '0';
begin

uut : entity work.dummy_top
port map(
    aclk            => aclk,
    aresetn         => aresetn,
    
    s_axi_awaddr    => m_axi_awaddr,
    s_axi_awprot    => m_axi_awprot,
    s_axi_awvalid   => m_axi_awvalid,
    s_axi_awready   => m_axi_awready,
    
    s_axi_wdata     => m_axi_wdata,
    s_axi_wstrb     => m_axi_wstrb,
    s_axi_wvalid    => m_axi_wvalid,
    s_axi_wready    => m_axi_wready,
    
    s_axi_bresp     => m_axi_bresp,
    s_axi_bvalid    => m_axi_bvalid,
    s_axi_bready    => m_axi_bready,
    
    s_axi_araddr    => m_axi_araddr,
    s_axi_arprot    => m_axi_arprot,
    s_axi_arvalid   => m_axi_arvalid,
    s_axi_arready   => m_axi_arready,
    
    s_axi_rdata     => m_axi_rdata,
    s_axi_rresp     => m_axi_rresp,
    s_axi_rvalid    => m_axi_rvalid,
    s_axi_rready    => m_axi_rready,
    
    s_axis_tready   => m_tready,
    s_axis_tdata    => m_tdata,
    s_axis_tlast    => m_tlast,
    s_axis_tvalid   => m_tvalid,
    
    m_axis_tready   => s_tready,
    m_axis_tdata    => s_tdata,
    m_axis_tlast    => s_tlast,
    m_axis_tvalid   => s_tvalid
);

clock_100MHz : process
begin

    wait for C_PERIOD / 2;
    aclk <= not aclk;
    
end process;

stimulus : process 
begin
    -- Reset
    aresetn <= '0'; 
    for i in 0 to 10 loop
        wait until rising_edge(aclk); 
    end loop; 
    aresetn <= '1';
    
    -- Configuration Interface
        -- set count in
    m_axi_awaddr  <= x"0";
    m_axi_awvalid <= '1';
    m_axi_wdata   <= x"0000000a";
    m_axi_wvalid  <= '1';
    
    wait until m_axi_awready = '1';
    wait until rising_edge(aclk);
    
        -- set count out
    m_axi_awaddr  <= x"4";
    m_axi_awvalid <= '1';    
    m_axi_wdata   <= x"00000005";
    m_axi_wvalid  <= '1';

    wait until m_axi_awready = '1';
    wait until rising_edge(aclk);
    
    -- enable
    m_axi_awaddr  <= x"8";
    m_axi_awvalid <= '1';    
    m_axi_wdata   <= x"ffffffff";
    m_axi_wvalid  <= '1';

    wait until m_axi_awready = '1';
    wait until rising_edge(aclk);
    
    m_axi_awvalid <= '0';
    m_axi_wvalid  <= '0';
    
    -- Stream Interface
    s_tready  <= '1'; -- always ready to accept data
    
    wait until rising_edge(aclk);
    
    m_tvalid <= '1'; -- start transmiting data 
    
        -- Transaction 1 
    m_tdata  <= x"00000001";
    
    if m_tready = '0' then
        wait until m_tready = '1';
    end if;
    
    wait until rising_edge(aclk);
    
        -- Transaction 2 
    m_tdata  <= x"00000002";
    
    if m_tready = '0' then
        wait until m_tready = '1';
    end if;
    
    wait until rising_edge(aclk);
    
        -- Transaction 3
    m_tdata  <= x"00000003";
    
    if m_tready = '0' then
        wait until m_tready = '1';
    end if;
    
    wait until rising_edge(aclk);
    
        -- Transaction 4
    m_tdata  <= x"00000004";
    
    if m_tready = '0' then
        wait until m_tready = '1';
    end if;
    
    wait until rising_edge(aclk);
    
        -- Transaction 5
    m_tdata  <= x"00000005";
    
    if m_tready = '0' then
        wait until m_tready = '1';
    end if;
    
    wait until rising_edge(aclk);
    
        -- Transaction 6
    m_tdata  <= x"00000006";
    
    if m_tready = '0' then
        wait until m_tready = '1';
    end if;
    
    wait until rising_edge(aclk);
    
        -- Transaction 7
    m_tdata  <= x"00000007";
    
    if m_tready = '0' then
        wait until m_tready = '1';
    end if;
    
    wait until rising_edge(aclk);
    
        -- Transaction 8
    m_tdata  <= x"00000008";
    
    if m_tready = '0' then
        wait until m_tready = '1';
    end if;
    
    wait until rising_edge(aclk);
        
        -- Transaction 9
    m_tdata  <= x"00000009";
    
    if m_tready = '0' then
        wait until m_tready = '1';
    end if;
    
    wait until rising_edge(aclk);
        
        -- Transaction 10
    m_tlast  <= '1'; -- this is the last transaction 
    
    m_tdata  <= x"0000000a";
    
    if m_tready = '0' then
        wait until m_tready = '1';
    end if;
    
    wait until rising_edge(aclk);
    
    -- Terminate the stimulus
    m_tvalid <= '0';
    m_tlast  <= '0';

    wait;
end process;

end Behavioral;