#!/usr/bin/bash
# Creator      : Ronaldo Tsela
# Description  : This script is used to place the PetaLinux boot components onto the SD card.
# Usage        : ./setup-sd.sh <project path>
# Input        : project path : Full path to the project

if [ -z "$1" ]; then
    echo "Usage: $0 <project-path>"
    exit 1
fi

path="$1"

# chose $path/image if you want to configure the SD with the custom PetaLinux image components
# chose $path/prebuilt-image if you want to configure the SD with the prebuilt image components

#image_path="$path/image"
image_path="$path/prebuilt-image"

# Copy boot components to BOOT partition
cp "$image_path/BOOT.BIN" "$image_path/image.ub" "$image_path/boot.scr" "$image_path/system.dtb" "/media/$USER/BOOT"

# Extract the root file system to ROOTFS partition
sudo tar -xvf "$image_path/rootfs.tar.gz" -C "/media/$USER/ROOTFS"

# Compile and move the applications to ROOTFS partition under /usr/bin/
make -C "$path/src/"
sudo cp "$path/src/dummy-worker" "/media/$USER/ROOTFS/usr/bin"
sudo chmod a+x "/media/$USER/ROOTFS/usr/bin/dummy-worker"
make -C "$path/src/" clean

make -C "$path/autotest/"
sudo cp "$path/autotest/test_gen" "/media/$USER/ROOTFS/usr/bin"
sudo chmod a+x "/media/$USER/ROOTFS/usr/bin/test_gen"
make -C "$path/autotest/" clean

# Move the automated test script to ROOTFS partition under root /test/
sudo mkdir -p "/media/$USER/ROOTFS/test"
sudo cp "$path/autotest/test_run.sh" "/media/$USER/ROOTFS/test"
sudo chmod a+x "/media/$USER/ROOTFS/test/test_run.sh"

# Synchronize and unmount the SD
echo "Synchronizing ..."
sync

echo "SD Memory card is ready!"
