#!/bin/bash
# Creator     : Ronaldo Tsela
# Description : This script is used to test the Dummy SoC with various configurations. Output is loged in log.txt.
#               Randomly generated data are created using test_gen program.

file_in="in.raw"                            # This is the input file
file_out="out.raw"                          # This is the output file
max=10                                      # Upper limit for random data generator
min=0                                       # Lower limit for random data generator
count_in=(1024 2048 8192 16384 32768)       # Range of input size in words
logfile="log.txt"                           # Here will be placed the output from the program

# Start testing set 1: transmit n_in words and read 512 back
for n_in in "${count_in[@]}"; do	

    sudo test_gen "$file_in" "$n_in" "$max" "$min" >> "$logfile"
    sudo dummy-worker "$file_in" "$file_out" "$n_in" 512 >> "$logfile"

    # Compare the first 512 words of $file_in with $file_out
    if cmp -n 2048 "$file_in" "$file_out"; then
        echo "Test Completed Successfully. Results are printed in log.txt"
    else
        echo "Test failed: $file_in and $file_out do not match."
    fi
done
# Test 1 ends here

echo "Tests completed. Exiting"

sudo rm $file_in $file_out
