library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

entity sr_latch is
    Port (
        S : in STD_LOGIC;    -- Set input
        R : in STD_LOGIC;    -- Reset input
        Q : out STD_LOGIC;   -- Q output
        Qn : out STD_LOGIC   -- Q' (complement of Q) output
    );
end sr_latch;

architecture Behavioral of sr_latch is
begin
    process(S, R)
    begin
        if S = '1' and R = '0' then
            Q <= '1';
            Qn <= '0';
        elsif S = '0' and R = '1' then
            Q <= '0';
            Qn <= '1';
        elsif S = '0' and R = '0' then  -- No action, keep values
        else              -- Invalid state (S = '1' and R = '1')
            Q <= 'X';  -- Indeterminate state
            Qn <= 'X';
        end if;
    end process;
end Behavioral;

architecture Dataflow of sr_latch is

    signal Q_in   : STD_LOGIC := '0';  -- Internal feedback for Q
    signal Qn_in : STD_LOGIC := '1'; -- Internal feedback for Q'

begin
    -- Concurrent feedback logic
    Q_in   <= R nor (S nor Q_in);   -- Q feedback
    Qn_in  <= S nor (R nor Qn_in); -- Q' feedback

    -- Map internal signals to outputs
    Q <= Q_in;
    Qn <= Qn_in;

end Dataflow;

architecture DF of sr_latch is

    signal Q_in   : STD_LOGIC := '0';  -- Internal feedback for Q
    signal Qn_in : STD_LOGIC := '1'; -- Internal feedback for Q'

begin

    -- Concurrent feedback logic
    Q_in   <= R nor Qn_in;   -- Q feedback
    Qn_in  <= S nor Q_in; -- Q' feedback

    -- Map internal signals to outputs
    Q <= Q_in;
    Qn <= Qn_in;

end DF;



library ieee;
use ieee.std_logic_1164.all;use ieee.numeric_std.ALL;

entity accumulator is

port ( 	
    clk: in std_logic;
 	reset : in std_logic;
	data_in : in std_logic_vector(15 downto 0); 
	data_out : out std_logic_vector(19 downto 0));

end entity accumulator;

architecture rtl of accumulator is

signal sum, new_sum : signed(19 downto 0); 
begin
	new_sum <= sum + resize(signed(data_in), sum'length); 
	reg: 	process (clk) is
	begin
		if rising_edge(clk) then
			if reset = '1' then
				sum <= (others => '0'); 
			else
				sum <= new_sum;
			end if;
		end if;
	end process reg;
	
	data_out <= std_logic_vector(sum);
end architecture rtl;

