library ieee;
use ieee.std_logic_1164.all;use ieee.numeric_std.ALL;

entity accumulator is

port ( 	
    clk: in std_logic;
 	reset : in std_logic;
	data_in : in std_logic_vector(15 downto 0); 
	data_out : out std_logic_vector(19 downto 0));

end entity accumulator;

architecture rtl of accumulator is

signal sum, new_sum : signed(19 downto 0); 
begin
	new_sum <= sum + resize(signed(data_in), sum'length); 
	reg: 	process (clk) is
	begin
		if rising_edge(clk) then
			if reset = '1' then
				sum <= (others => '0'); 
			else
				sum <= new_sum;
			end if;
		end if;
	end process reg;
	
	data_out <= std_logic_vector(sum);
end architecture rtl;

