library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

entity d_latch is
    Port (
        D : in STD_LOGIC;    -- Data input
        CLK : in STD_LOGIC;  -- Clock input
        Q : out STD_LOGIC;   -- Output
        Qn : out STD_LOGIC   -- Complementary output
    );
end d_latch;

architecture Behavioral of d_latch is

signal Q_in : STD_LOGIC := '0';  -- Internal signal for Q

begin

    -- Latch behavior with concurrent assignments
    Q_in <= D when CLK = '1' else 
	Q_in;  	

    Q <= Q_in;                  -- Assign internal signal to Q
    Qn <= not Q_in;         -- Complementary output

end Behavioral;
