library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

entity bcd2sevenseg is
port (
      digit_selection_in    : in std_logic;                     -- Digit Selection input
      bcd                   : in std_logic_vector(3 downto 0);  -- BCD input
      seven_segment         : out std_logic_vector(6 downto 0); -- 7-segment output MSBit is g, LSBit is a
      digit_selection_out   : out std_logic                     -- Digit Selection Pin for PmodSSD
    );
end bcd2sevenseg;

architecture Behavioral of bcd2sevenseg is

begin

-- Insert your code here
-- Use ONLY process with case statement

bcd_values: process (bcd) begin

case bcd is

    when X"0" => seven_segment   <="0111111";    -- 0 Χ"0" means 0 in Hex=>0000
    when X"1" => seven_segment   <="0000110";    -- 1 Χ"1" means 1 in Hex=>0001
    when X"2" => seven_segment   <="1011011";    -- 2 ..
    when X"3" => seven_segment   <="1001111";    -- 3 ..
    when X"4" => seven_segment   <="1100110";    -- 4
    when X"5" => seven_segment   <="1101101";    -- 5
    when X"6" => seven_segment   <="1111101";    -- 6
    when X"7" => seven_segment   <="0000111";    -- 7
    when X"8" => seven_segment   <="1111111";    -- 8
    when X"9" => seven_segment   <="1101111";    -- 9
    when others => seven_segment <="0000000";
    
    
end case;

--Dataflow Edition

--with bcd select
--seven_segment<="0111111" when "0000",
--                     "0000110" when "0001",
--	               "1011011" when "0010",
--	               "1001111" when "0011",
--	               "1100110" when "0100",
--	               "1101101" when "0101",
--	               "1111101" when "0110",
--	               "0000111" when "0111",
--	               "1111111" when "1000",
--	               "1101111" when "1001",
--	               "0000000" when others;
--
--digit_selection_out <=digit_selection_in;


end process bcd_values;

digit_selection_out <=digit_selection_in;

end Behavioral;

