----------------------------------------------------------------------------------
-- Company: 
-- Engineer: 
-- 
-- Create Date: 12/04/2023 09:36:40 AM
-- Design Name: 
-- Module Name: Adder_8bit - Behavioral
-- Project Name: 
-- Target Devices: 
-- Tool Versions: 
-- Description: 
-- 
-- Dependencies: 
-- 
-- Revision:
-- Revision 0.01 - File Created
-- Additional Comments:
-- 
----------------------------------------------------------------------------------


library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
--use IEEE.NUMERIC_STD.ALL;

-- Uncomment the following library declaration if instantiating
-- any Xilinx leaf cells in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity Adder_8bit is
    generic (WIDTH : positive:=8);
    Port ( A_8bit : in STD_LOGIC_VECTOR(WIDTH-1 downto 0);
           B_8bit : in STD_LOGIC_VECTOR(WIDTH-1 downto 0);
           Cin_8bit : in STD_LOGIC;
           Sum_8bit : out STD_LOGIC_VECTOR(WIDTH-1 downto 0);
           Cout_8bit : out STD_LOGIC);
end Adder_8bit;

architecture Structural of Adder_8bit is

component Adder_4bit is
    
    Port ( A, B : in STD_LOGIC_VECTOR(3 downto 0);
           Cin : in STD_LOGIC;
           Sum : out STD_LOGIC_VECTOR(3 downto 0);
           Cout : out STD_LOGIC);
end component Adder_4bit;

signal Carry_next : std_logic;
           
begin

first_half: Adder_4bit port map(A_8bit(3 downto 0), B_8bit(3 downto 0), '0', Sum_8bit(3 downto 0), Carry_next);
second_half: Adder_4bit port map(A_8bit(WIDTH-1 downto 4), B_8bit(WIDTH-1 downto 4), Carry_next, Sum_8bit(WIDTH-1 downto 4), Cout_8bit);

end Structural;
