library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

entity Adder_4bit is
    
    Port ( A, B : in STD_LOGIC_VECTOR(3 downto 0);
           Cin : in STD_LOGIC;
           Sum : out STD_LOGIC_VECTOR(3 downto 0);
           Cout : out STD_LOGIC);
           
end entity Adder_4bit;

architecture Dataflow of Adder_4bit is

signal temp_sum: unsigned(4 downto 0):=(others=>'0');
begin

temp_sum<=unsigned('0'&A)+unsigned('0'&B)+("000"&Cin);    
Sum <= std_logic_vector(temp_sum(3 downto 0));
Cout <= temp_sum(4);

end architecture Dataflow ;