----------------------------------------------------------------------------------
-- Company: 
-- Engineer: 
-- 
-- Create Date: 12/04/2023 09:50:33 AM
-- Design Name: 
-- Module Name: Adder_8bit_tb - Behavioral
-- Project Name: 
-- Target Devices: 
-- Tool Versions: 
-- Description: 
-- 
-- Dependencies: 
-- 
-- Revision:
-- Revision 0.01 - File Created
-- Additional Comments:
-- 
----------------------------------------------------------------------------------


library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
--use IEEE.NUMERIC_STD.ALL;

-- Uncomment the following library declaration if instantiating
-- any Xilinx leaf cells in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity Adder_8bit_tb is

end Adder_8bit_tb;

architecture Behavioral of Adder_8bit_tb is

constant WIDTH : positive:=8;

component  Adder_8bit is
   
    Port ( A_8bit : in STD_LOGIC_VECTOR(WIDTH-1 downto 0);
           B_8bit : in STD_LOGIC_VECTOR(WIDTH-1 downto 0);
           Cin_8bit : in STD_LOGIC:='0';
           Sum_8bit : out STD_LOGIC_VECTOR(WIDTH-1 downto 0);
           Cout_8bit : out STD_LOGIC);
end component Adder_8bit;


signal A_8bit_tb : STD_LOGIC_VECTOR(WIDTH-1 downto 0);
signal B_8bit_tb : STD_LOGIC_VECTOR(WIDTH-1 downto 0);
signal Cin_8bit_tb : STD_LOGIC;
signal Sum_8bit_tb : STD_LOGIC_VECTOR(WIDTH-1 downto 0);
signal Cout_8bit_tb : std_logic;

begin

uut: Adder_8bit port map (A_8bit_tb, B_8bit_tb, Cin_8bit_tb, Sum_8bit_tb, Cout_8bit_tb);

test: process is
begin

A_8bit_tb<="10000000";B_8bit_tb<="10000000";Cin_8bit_tb<='0'; wait for 20 ns;
A_8bit_tb<="00001000";B_8bit_tb<="00001000";Cin_8bit_tb<='0'; wait for 20 ns;
A_8bit_tb<="01001000";B_8bit_tb<="01001000";Cin_8bit_tb<='0'; wait for 20 ns;
wait for 20ns;
end process test;


end Behavioral;
