library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
--use IEEE.NUMERIC_STD.ALL;

-- Uncomment the following library declaration if instantiating
-- any Xilinx leaf cells in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity DSD_Lab3 is
    Port ( data1_in : in STD_LOGIC_VECTOR (1 downto 0);
           data2_in : in STD_LOGIC_VECTOR (1 downto 0);
           data1_out : out STD_LOGIC;
           data2_out : out STD_LOGIC_VECTOR (1 downto 0));
end entity DSD_Lab3;

--architecture DF of DSD_Lab3 is

--begin

--data1_out<=   not( data1_in(0) xor data1_in(1) xor  data2_in(0) xor data2_in(1));       --xnor
--data2_out<=data1_in xor data2_in;

--end architecture DF;

--architecture Beh of DSD_Lab3 is

--begin

--beh_arc: process (data1_in, data2_in) is
--begin
--data1_out<=   not( data1_in(0) xor data1_in(1) xor  data2_in(0) xor data2_in(1));       --xnor
--data2_out<=data1_in xor data2_in;
--end process beh_arc;

--end architecture Beh;

architecture Structural of DSD_Lab3 is

component Xor_Gate is
    Port ( I0 : in STD_LOGIC;
           I1 : in STD_LOGIC;
           O : out STD_LOGIC);
end component Xor_Gate;

component Not_Gate is
    Port ( I0 : in STD_LOGIC;
           O : out STD_LOGIC);
end component Not_Gate;

signal temp_xor1 :  STD_LOGIC;
signal temp_xor2 :  STD_LOGIC;
signal temp_xor3 :  STD_LOGIC;

begin


xor1: Xor_Gate port map(data1_in(0),data1_in(1), temp_xor1);
xor2: Xor_Gate port map(data2_in(0),data2_in(1), temp_xor2);
xor3: Xor_Gate port map(temp_xor1,temp_xor2, temp_xor3);
not1: Not_gate port map(temp_xor3, data1_out);

xor4: Xor_Gate port map(data1_in(0),data2_in(0), data2_out(0));
xor5: Xor_Gate port map(data1_in(1),data2_in(1), data2_out(1));

end architecture Structural;
