library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.numeric_std.all;

-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
--use IEEE.NUMERIC_STD.ALL;

-- Uncomment the following library declaration if instantiating
-- any Xilinx leaf cells in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity lect_6b is
    Port (  signal1_in  : in STD_LOGIC_VECTOR(3 downto 0);
            signal2_in  : in unsigned (3 downto 0);
            signal3_in  : in signed (3 downto 0);
            signal4_in  : in integer range -16 to 15;
            signal1_out  : out STD_LOGIC_VECTOR(3 downto 0);
            signal2_out  : out unsigned (3 downto 0);
            signal3_out  : out signed (3 downto 0);
            signal4_out  : out integer range -16 to 15
          );
end lect_6b;

architecture Behavioral of lect_6b is

signal signal_temp : STD_LOGIC_VECTOR(7 downto 0);

begin

--  uncomment    Part        simulation

--A part
--signal1_out<=std_logic_vector(signal2_in);          --unsigned to std_logic_vector
------  or
---- signal1_out<=std_logic_vector(signal3_in);       --signed to std_logic_vector
--signal2_out<=unsigned(signal3_in);                  --std_logic_vector to unsigned
--signal3_out<=signed(signal2_in);                    --unsigned to sign
--signal4_out<=to_integer(signal3_in);                --signed to integer

---- B part
signal1_out<=std_logic_vector(signal2_in);                                      --unsigned to std_logic_vector
signal2_out<=(to_unsigned(signal4_in,signal2_out'length));                      --integer to unsigned
signal3_out<=to_signed(signal4_in,signal3_out'length);                          --integer to signed
signal4_out<=to_integer(signed(signal1_in));                                    --std_logic_vector to integer

end Behavioral;
