LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
USE ieee.numeric_std.ALL;
USE std.env.all;
    
entity test_tb IS
end test_tb;

architecture behavior OF test_tb IS 
 
    -- Component Declaration for the Unit Under Test (UUT)
    component test 
    port (
      clk     : in std_logic;
      reset   : in std_logic;
      In_1    : in std_logic;                     
      Out_1   : out std_logic                     
    );
    end component;
  	--Inputs
	signal clk       : std_logic;
	signal reset            : std_logic;
	signal In_1      : std_logic;
  	--Outputs
	signal Out_1           : std_logic;

-- Clock period definitions
constant CLK_period : time := 10 ns;
	

begin

 	-- Instantiate the Unit Under Test (UUT)
   uut: test PORT MAP (clk, reset, In_1, Out_1);

-- Clock process definition
CLK_process : process
    begin
		CLK <= '0';
		wait for clk_period/2;
		CLK <= '1';
		wait for clk_period/2;
    end process;
    
test_proc: process is
begin		

		RESET <= '1';
        wait for 100 ns;
        wait until (CLK = '0' and CLK'event);
		RESET <= '0';
		
   In_1<='1';wait for 20ns;
   report "test1";
   In_1<='1';wait for 20ns;

   In_1<='X';
   wait for 20ns;
   assert (Out_1='0' or Out_1='1') report "wrong value OUT" severity error;
   assert (In_1='0' or In_1='1') report "wrong value IN1" severity error;
   assert false report "wrong value IN2" severity error;      
   In_1<='0';report "test2" severity error;wait for 20ns;
   In_1<='1';wait for 20ns;

end process test_proc;
 
end architecture behavior;

