library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
use IEEE.NUMERIC_STD.ALL;


entity lect_6d_tb is
--  Port ( );
end lect_6d_tb;

-- FIRST CASE: STD_LOGIC EDITION
--architecture Behavioral of lect_6d_tb is

--component lect_6d is
--port (
--signal a: in  std_logic_vector(4 downto 0);
--signal b: in  std_logic_vector(4 downto 0);
--signal c: out std_logic_vector(4 downto 0);
--signal d: out std_logic_vector(4 downto 0);
--signal e: out integer range 0 to 15
--);
--end component lect_6d;


---- Internal signals 

--signal a1, b1   : std_logic_vector(4 downto 0); --Port map signals
--signal c1       : std_logic_vector(4 downto 0);
--signal d1       : std_logic_vector (4 downto 0);
--signal e1       : integer range 0 to 15;
--signal f, g, h  : std_logic_vector(2 downto 0); --For the shake of the tests


--begin 

--uut: lect_6d port map(a=>a1,b=>b1,c=>c1, d=>d1, e=>e1);

-- -- No wait - Does not stop
--applytest: process
--begin
--   a1<="11100";b1<="00111";
--   wait;
--end process;

--end Behavioral;

-- SECOND CASE: UNSIGNED EDITION
--architecture Behavioral of lect_6d_tb is

--component lect_6d is
--port (
--signal a: in  unsigned(4 downto 0);
--signal b: in  unsigned(4 downto 0);
--signal c: out unsigned(4 downto 0);
--signal d: out unsigned(4 downto 0);
--signal e: out integer range 0 to 15
--);
--end component lect_6d;


---- Internal signals 

--signal a1, b1   : unsigned(4 downto 0); --Port map signals
--signal c1       : unsigned(4 downto 0);
--signal d1       : unsigned (4 downto 0);
--signal e1       : integer range 0 to 15;
--signal f, g, h  : unsigned(2 downto 0); --For the shake of the tests


--begin 

--uut: lect_6d port map(a=>a1,b=>b1,c=>c1, d=>d1, e=>e1);

-- -- No wait - Does not stop
--applytest: process
--begin
--   a1<="11100";b1<="00111";
--   wait;
--end process;

--end Behavioral;

-- THIRD CASE: SIGNED EDITION
architecture Behavioral of lect_6d_tb is

component lect_6d is
port (
signal a: in  signed(4 downto 0);
signal b: in  signed(4 downto 0);
signal c: out signed(4 downto 0);
signal d: out signed(4 downto 0);
signal e: out integer range 0 to 15
);
end component lect_6d;


-- Internal signals 

signal a1, b1   : signed(4 downto 0); --Port map signals
signal c1       : signed(4 downto 0);
signal d1       : signed (4 downto 0);
signal e1       : integer range 0 to 15;
signal f, g, h  : signed(2 downto 0); --For the shake of the tests


begin 

uut: lect_6d port map(a=>a1,b=>b1,c=>c1, d=>d1, e=>e1);

 -- No wait - Does not stop
applytest: process
begin
   a1<="11100";b1<="00111";
   wait;
end process;

end Behavioral;