library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.NUMERIC_STD.ALL;


-- FIRST CASE: STD_LOGIC EDITION

entity lect_6d is
port (
signal a: in  std_logic_vector(4 downto 0);
signal b: in  std_logic_vector(4 downto 0);
signal c: out std_logic_vector(4 downto 0);
signal d: out std_logic_vector(4 downto 0);
signal e: out integer range 0 to 15
);
end lect_6d;

architecture Behavioral of lect_6d is

signal x,y,z,w,q,u,r,t,i,o : std_logic_vector(4 downto 0);
signal f : std_logic_vector(4 downto 0):="11111";

begin               

c<=a;           --Just to make RTL Analysis-Schematic
                
--NOTHING is Working in Standard VHDL
--YOU HAVE TO ACTIVATE VHDL 2008 in order to enable logical shifts and rotations
--OR
--MAKE THE COMMAND ON YOYR OWN

x<=a sll 2;     --Logical Shift works
y<=a srl 2;     --Logical Shift works
z<=a sla 2;     
w<=a sra 2;
q<=a rol 2;     --Logical Shift works
u<=a ror 2;     --Logical Shift works
r<=shift_left(a,2);
t<=shift_right(a,2);
i<=rotate_left(a,2);
o<=rotate_right(a,2);


end Behavioral;

--library IEEE;
--use IEEE.STD_LOGIC_1164.ALL;
--use IEEE.NUMERIC_STD.ALL;

---- SECOND CASE: UNSIGNED

--entity lect_6d is
--port (
--signal a: in  unsigned(4 downto 0);
--signal b: in  unsigned(4 downto 0);
--signal c: out unsigned(4 downto 0);
--signal d: out unsigned(4 downto 0);
--signal e: out integer range 0 to 15
--);
--end lect_6d;

--architecture Behavioral of lect_6d is

--signal x,y,z,w,q,u,r,t,i,o : unsigned(4 downto 0);
--signal f : std_logic_vector(4 downto 0):="11111";
 
--begin

--c<=a;           --Just to make RTL Analysis-Schematic

--x<=a sll 2;     --Logical Shift works
--y<=a srl 2;
--z<=a sla 2;     --Arithmetic Shifts not working in standard VHDL. THEY ONLY WORK in VHDL 2008
--w<=a sra 2;     --Arithmetic Shifts not working in standard VHDL. THEY ONLY WORK in VHDL 2008
--q<=a rol 2;
--u<=a ror 2;
--r<=shift_left(a,2);
--t<=shift_right(a,2);
--i<=rotate_left(a,2);
--o<=rotate_right(a,2);

--end Behavioral;

--library IEEE;
--use IEEE.STD_LOGIC_1164.ALL;
--use IEEE.NUMERIC_STD.ALL;

---- THIRD CASE: SIGNED

--entity lect_6d is
--port (
--signal a: in  signed(4 downto 0);
--signal b: in  signed(4 downto 0);
--signal c: out signed(4 downto 0);
--signal d: out signed(4 downto 0);
--signal e: out integer range 0 to 15
--);
--end lect_6d;

--architecture Behavioral of lect_6d is

--signal x,y,z,w,q,u,r,t,i,o : signed(4 downto 0);
--signal f : std_logic_vector(4 downto 0):="11111";
 
--begin

--c<=a;           --Just to make RTL Analysis-Schematic

--x<=a sll 2;     --Logical Shift works
--y<=a srl 2;
--z<=a sla 2;     --Arithmetic Shifts not working in standard VHDL. THEY ONLY WORK in VHDL 2008
--w<=a sra 2;     --Arithmetic Shifts not working in standard VHDL. THEY ONLY WORK in VHDL 2008
--q<=a rol 2;
--u<=a ror 2;
--r<=shift_left(a,2);
--t<=shift_right(a,2);
--i<=rotate_left(a,2);
--o<=rotate_right(a,2);

--end Behavioral;