library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.numeric_std.ALL;

entity Counter is
port (
      clk                   : in std_logic;
      reset                 : in std_logic;
      direction             : in std_logic;
      led_result            : out std_logic_vector(6 downto 0); -- LED Result input
      seven_segment         : out std_logic_vector(6 downto 0); -- 7-segment output MSBit is g, LSBit is a
      digit_selection_out   : out std_logic                     -- Digit Selection Pin for PmodSSD
    );
end entity Counter;

architecture Behavioral of Counter is

--constant TICKS: positive :=500000;
constant TICKS: positive :=5;

signal clk_100MHz: std_logic;                             --NEW CLOCK. Ticks every sec
signal sum: unsigned(6 downto 0);                         --Running timer value
signal right_digit: unsigned(3 downto 0);                      --Right digit in decimal
signal left_digit: unsigned(3 downto 0);                      --Left digit in decimal
signal seven_segment_left: std_logic_vector(6 downto 0);  --Left Pmod Digit
signal seven_segment_right: std_logic_vector(6 downto 0); --Right Pmod Digit 
signal digit_selection: std_logic;                        --Choose pmod digit

begin

-- Insert your code here
-- Use ONLY process with case statement

-- Create NEW CLOCK that ticks every 1 sec;


One_sec_clk : process (clk, reset) is

variable clk_ticks : integer;

begin

	if reset = '1' then
	
	   clk_100MHz<='0';
       clk_ticks :=0;
       
	elsif rising_edge(clk) then
	
		if clk_ticks = 99999999 then
--		if clk_ticks = 1 then
			clk_ticks := 0;
			clk_100MHz 	<= '1';
		else
			clk_ticks := clk_ticks + 1;
			clk_100MHz <= '0';
		end if; -- clk_ticks
		
	end if; --reset

end process One_sec_clk;
	

count: process (clk, reset) is

begin

if (reset='1') then

    sum<=(others=>'0');

elsif rising_edge(clk) then

    if clk_100MHz='1' then 
        if direction='1' then
    
            if sum<99 then 
                sum<=sum+1;
            else
                sum<=(others=>'0');
            end if; -- sum<99
    
        else
    
            if sum>0 then 
                sum<=sum-1;
            else
                sum<="1100011";
            end if; -- sum>0
    
        end if; --direction
    end if;

end if; --reset

end process count;

digit_process: process (clk, reset) is

variable clk_ticks : integer;

begin

	if reset = '1' then
	
       clk_ticks :=0;
       digit_selection<='0';
       seven_segment<=(others=>'0');
    
	elsif rising_edge(clk) then
	
		if clk_ticks = TICKS then
			clk_ticks := 0;
		    if digit_selection='0' then
		          digit_selection<='1';
		          seven_segment<=seven_segment_left;
		    else
		          digit_selection<='0';
		          seven_segment<=seven_segment_right;
		    end if;
		else
			clk_ticks := clk_ticks + 1;
			
		end if; -- clk_ticks
		
	end if; --reset
	
end process digit_process;


---- *************************
---- COMBINATIONAL FOR OUTPUT
---- *************************

--LED Output
led_result<=std_logic_vector(sum);      

----PMOD Output

left_digit<=resize(sum/10, left_digit'length);     --Tens
right_digit<=resize(sum mod 10, right_digit'length); --Units

-- create right Pmod digit
bcd_right_digit_values: process (right_digit) begin

case right_digit is

    when X"0" => seven_segment_right   <="0111111";    -- 0
    when X"1" => seven_segment_right   <="0000110";    -- 1
    when X"2" => seven_segment_right   <="1011011";    -- 2
    when X"3" => seven_segment_right   <="1001111";    -- 3
    when X"4" => seven_segment_right   <="1100110";    -- 4
    when X"5" => seven_segment_right   <="1101101";    -- 5
    when X"6" => seven_segment_right   <="1111101";    -- 6
    when X"7" => seven_segment_right   <="0000111";    -- 7
    when X"8" => seven_segment_right   <="1111111";    -- 8
    when X"9" => seven_segment_right   <="1101111";    -- 9
    when others => seven_segment_right <="0000000";
    
    
end case;

-- create left Pmod digit

end process bcd_right_digit_values;

bcd_left_digit_values: process (left_digit) begin

case left_digit is

    when X"0" => seven_segment_left   <="0111111";    -- 0
    when X"1" => seven_segment_left   <="0000110";    -- 1
    when X"2" => seven_segment_left   <="1011011";    -- 2
    when X"3" => seven_segment_left   <="1001111";    -- 3
    when X"4" => seven_segment_left   <="1100110";    -- 4
    when X"5" => seven_segment_left   <="1101101";    -- 5
    when X"6" => seven_segment_left   <="1111101";    -- 6
    when X"7" => seven_segment_left   <="0000111";    -- 7
    when X"8" => seven_segment_left   <="1111111";    -- 8
    when X"9" => seven_segment_left   <="1101111";    -- 9
    when others => seven_segment_left <="0000000";
    
    
end case;

end process bcd_left_digit_values;


digit_selection_out<=digit_selection;

-- Pmod Digit Value
--seven_segment<=seven_segment_right when digit_selection='0' else seven_segment_left when digit_selection='1' else (others=>'0');

end Behavioral;

