library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.numeric_std.ALL;

entity Simpler is
port (
      clk                   : in std_logic;
      reset                 : in std_logic;
      direction             : in std_logic;
      led_result            : out std_logic_vector(6 downto 0); -- LED Result input
      seven_segment         : out std_logic_vector(6 downto 0); -- 7-segment output MSBit is g, LSBit is a
      digit_selection_out   : out std_logic                     -- Digit Selection Pin for PmodSSD
    );
end entity Simpler;

architecture Behavioral of Simpler is

constant TICKS: positive  :=  1024;
constant ONESEC: positive :=100000000;

signal sum: unsigned(6 downto 0);                         --Running timer value
signal new_sum: unsigned(6 downto 0);
signal right_digit: unsigned(3 downto 0);                      --Right digit in decimal
signal left_digit: unsigned(3 downto 0);                      --Left digit in decimal
signal seven_segment_left: std_logic_vector(6 downto 0);  --Left Pmod Digit
signal seven_segment_right: std_logic_vector(6 downto 0); --Right Pmod Digit 
signal digit_selection: std_logic;                        --Choose pmod digit
signal new_digit_selection: std_logic;                        --Choose pmod digit
signal clk_ticks : integer range 0 to ONESEC:=0;
signal new_clk_ticks : integer range 0 to ONESEC:=0;
--signal clk_one_sec: std_logic;                             --NEW CLOCK. Ticks every sec  --OK


begin

-- Insert your code here
-- Use ONLY process with case statement

-- Count clk_ticks up to 100M

new_clk_ticks<=clk_ticks+1 when clk_ticks<ONESEC else 1;

count_ticks : process (clk, reset) is
begin
	if reset = '1' then
       clk_ticks <=0;       
	elsif rising_edge(clk) then	
		clk_ticks <= new_clk_ticks; 
	end if; --reset
end process count_ticks;

--clk_one_sec<='1' when clk_ticks=100000000 else '0'; --ALTERNAIVE SOLUTION
	
--Count seconds up and down
--count_sec: process(clk_one_sec) is                  --ALTERNAIVE SOLUTION
count_sec: process(clk_ticks) is
begin
--if clk_one_sec='1' then                             --ALTERNAIVE SOLUTION
if clk_ticks=100000000 then   
    if direction='1' then
        if sum<99 then 
            new_sum<=sum+1;
        else
            new_sum<=(others=>'0');
        end if; -- sum<99
    else
        if sum>0 then 
            new_sum<=sum-1;
        else
            new_sum<="1100011";
        end if; -- sum>0
    end if; --direction
else
    new_sum<=sum;        
end if;
end process count_sec;


count: process (clk, reset) is
begin
if (reset='1') then
    sum<=(others=>'0');
elsif rising_edge(clk) then
    sum<=new_sum;   
end if; --reset
end process count;


---- *************************
---- COMBINATIONAL FOR OUTPUT
---- *************************

--LED Output
led_result<=std_logic_vector(sum);      

----PMOD Output

left_digit<=resize(sum/10, left_digit'length);     --Tens
right_digit<=resize(sum mod 10, right_digit'length); --Units

-- create right Pmod digit
right_digit_values: process (right_digit) begin

case right_digit is
    when X"0" => seven_segment_right   <="0111111";    -- 0
    when X"1" => seven_segment_right   <="0000110";    -- 1
    when X"2" => seven_segment_right   <="1011011";    -- 2
    when X"3" => seven_segment_right   <="1001111";    -- 3
    when X"4" => seven_segment_right   <="1100110";    -- 4
    when X"5" => seven_segment_right   <="1101101";    -- 5
    when X"6" => seven_segment_right   <="1111101";    -- 6
    when X"7" => seven_segment_right   <="0000111";    -- 7
    when X"8" => seven_segment_right   <="1111111";    -- 8
    when X"9" => seven_segment_right   <="1101111";    -- 9
    when others => seven_segment_right <="1000000";
end case;
end process right_digit_values;

left_digit_values: process (left_digit) begin
case left_digit is
    when X"0" => seven_segment_left   <="0111111";    -- 0
    when X"1" => seven_segment_left   <="0000110";    -- 1
    when X"2" => seven_segment_left   <="1011011";    -- 2
    when X"3" => seven_segment_left   <="1001111";    -- 3
    when X"4" => seven_segment_left   <="1100110";    -- 4
    when X"5" => seven_segment_left   <="1101101";    -- 5
    when X"6" => seven_segment_left   <="1111101";    -- 6
    when X"7" => seven_segment_left   <="0000111";    -- 7
    when X"8" => seven_segment_left   <="1111111";    -- 8
    when X"9" => seven_segment_left   <="1101111";    -- 9
    when others => seven_segment_left <="0000000";
end case;
end process left_digit_values;


--LED Selection
-- Try TICKS a)to be power of 2 b)otherwise . What do you observe? Why?
-- a)Tc= 4.870 TICKS=8
-- b)Tc=10.962
-- There is also solution using more FFs for counting up to TICKS

new_digit_selection<= not digit_selection when (clk_ticks mod TICKS)=0 else 
                      digit_selection ;

select_digit: process (clk, reset) is
begin
if (reset='1') then
    digit_selection<='0';
elsif rising_edge(clk) then
    digit_selection<=new_digit_selection;   
end if; --reset
end process select_digit;

digit_selection_out<=digit_selection;


-- Pmod Digit Value
seven_segment<=seven_segment_right when digit_selection='0' else 
               seven_segment_left when digit_selection='1' else 
               "1000000";

end Behavioral;

-- The original solution involved Registers also for the output
