----------------------------------------------------------------------------------
-- Company: 
-- Engineer: 
-- 
-- Create Date: 11/28/2020 06:12:09 PM
-- Design Name: 
-- Module Name: ALU - Behavioral
-- Project Name: 
-- Target Devices: 
-- Tool Versions: 
-- Description: 
-- 
-- Dependencies: 
-- 
-- Revision:
-- Revision 0.01 - File Created
-- Additional Comments:
-- 
----------------------------------------------------------------------------------


library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
use IEEE.NUMERIC_STD.ALL;

-- Uncomment the following library declaration if instantiating
-- any Xilinx leaf cells in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity ALU is
    Port ( a        : in STD_LOGIC_VECTOR (2 downto 0);
           b        : in STD_LOGIC_VECTOR (2 downto 0);
           Ctr      : in STD_LOGIC;
           Result   : out STD_LOGIC_VECTOR (2 downto 0);
           Carry    : out STD_LOGIC
         );
end entity ALU;

architecture Behavioral of ALU is

--Signal used in all NO process Solution and the last one (process solution 7)
signal Result_temp  : unsigned (3 downto 0);
signal Control_Fix  : unsigned (3 downto 0);

begin

---------------------------------------------------------------

--Solution 1: NO CONDITIONAL STATEMENTS

--Control_Fix<=(others=>Ctr);
--Result_temp<=(unsigned('0'&a)+unsigned('0'&b) and not Control_Fix) or ((unsigned(A&'0') and Control_Fix));
--Result<=std_logic_vector(Result_temp(2 downto 0));
--Carry<=Result_temp(3);

---------------------------------------------------------------
--Solution 2: Type of Condition: Conditional signal assignment PLUS: NO Resize Function - YES

--Result_temp<=unsigned('0'&a)+unsigned('0'&b) when Ctr='0' else
--             unsigned(a&'0');
--Result<=std_logic_vector(Result_temp(2 downto 0));
--Carry<=Result_temp(3);

---------------------------------------------------------------

--Solution 3: Type of Condition: Conditional signal assignment - YES

--Result_temp<=resize(unsigned(a),Result_temp'length)+resize(unsigned(b),Result_temp'length) when Ctr='0' 
--        else resize(unsigned(a)*2,Result_temp'length);
--Result<=std_logic_vector(Result_temp(2 downto 0));
--Carry<=Result_temp(3);

---------------------------------------------------------------

--Solution 4: Use of Process and Variable. NO CONDITIONAL STATEMENTS

solution: process (a,b,Ctr) is

variable Control_Fix       : unsigned (3 downto 0);

begin

Control_Fix:=(others=>Ctr);
Result_temp<=(unsigned('0'&a)+unsigned('0'&b) and not Control_Fix) or ((unsigned(A&'0') and Control_Fix));
Result<=std_logic_vector(Result_temp(2 downto 0));
Carry<=Result_temp(3);

end process solution;

---------------------------------------------------------------

--Solution 5: Use of Process and Variable. Type of Condition: If.. then .. ElseIf .. else

--solution: process (a,b,Ctr) is

--variable Result_var       : unsigned (3 downto 0);

--begin

----Estimate Result

--if Ctr='0' then
--     Result_var:=unsigned('0'&a)+unsigned('0'&b); 
--elsif Ctr='1' then
--     Result_var:=unsigned(a&'0');
--else
--     Result_var:=resize("X",Result_var'length);
--end if; -- Ctr

--Result<=std_logic_vector(Result_var(2 downto 0));

----Estimate Carry

--Carry<=Result_var(3);

--end process solution_3;

-- NO if/select statements



end Behavioral;
