library IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE IEEE.NUMERIC_STD.ALL;
entity num_operator is
port(
    X   : in STD_LOGIC_VECTOR(3 downto 0);
    Y   : in STD_LOGIC_VECTOR(3 downto 0);
    Divi1  : out STD_LOGIC_VECTOR(3 downto 0);
    Modu1  : out STD_LOGIC_VECTOR(3 downto 0);
    Rema1  : out STD_LOGIC_VECTOR(3 downto 0);
    Divi2  : out STD_LOGIC_VECTOR(3 downto 0);
    Modu2  : out STD_LOGIC_VECTOR(3 downto 0);
    Rema2  : out STD_LOGIC_VECTOR(3 downto 0);
    Divi3  : out STD_LOGIC_VECTOR(3 downto 0);
    Modu3  : out STD_LOGIC_VECTOR(3 downto 0);
    Rema3  : out STD_LOGIC_VECTOR(3 downto 0);
    Divi4  : out STD_LOGIC_VECTOR(3 downto 0);
    Modu4  : out STD_LOGIC_VECTOR(3 downto 0);
    Rema4  : out STD_LOGIC_VECTOR(3 downto 0)    
);
end num_operator;

architecture Dataflow of num_operator is
begin


Divi1 <= std_logic_vector(signed(X) / signed(Y));
Modu1 <= std_logic_vector(signed(X) mod signed(Y));
Rema1 <= std_logic_vector(signed(X) rem signed(Y));

Divi2 <= std_logic_vector(unsigned(X) / unsigned(Y));
Modu2 <= std_logic_vector(unsigned(X) mod unsigned(Y));
Rema2 <= std_logic_vector(unsigned(X) rem unsigned(Y));

Divi4 <= std_logic_vector(to_unsigned(to_integer(unsigned(X) / unsigned(Y)),4));
Modu4 <= std_logic_vector(to_unsigned(to_integer(unsigned(X) mod unsigned(Y)),4));
Rema4 <= std_logic_vector(to_unsigned(to_integer(unsigned(X) rem unsigned(Y)),4));

Divi3 <= std_logic_vector(to_signed(to_integer(signed(X) / signed(Y)),4));
Modu3 <= std_logic_vector(to_signed(to_integer(signed(X) mod signed(Y)),4));
Rema3 <= std_logic_vector(to_signed(to_integer(signed(X) rem signed(Y)),4));



end Dataflow;